/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.RebuildEnvironmentRequest;

public class RebuildEnvironmentRequestMarshaller
implements Marshaller<Request<RebuildEnvironmentRequest>, RebuildEnvironmentRequest> {
    public Request<RebuildEnvironmentRequest> marshall(RebuildEnvironmentRequest rebuildEnvironmentRequest) {
        if (rebuildEnvironmentRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)rebuildEnvironmentRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "RebuildEnvironment");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (rebuildEnvironmentRequest.environmentId() != null) {
            request.addParameter("EnvironmentId", StringConversion.fromString((String)rebuildEnvironmentRequest.environmentId()));
        }
        if (rebuildEnvironmentRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringConversion.fromString((String)rebuildEnvironmentRequest.environmentName()));
        }
        return request;
    }
}

