/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformBuilder;

public class PlatformBuilderUnmarshaller
implements Unmarshaller<PlatformBuilder, StaxUnmarshallerContext> {
    private static final PlatformBuilderUnmarshaller INSTANCE = new PlatformBuilderUnmarshaller();

    public PlatformBuilder unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        PlatformBuilder.Builder platformBuilder = PlatformBuilder.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("ARN", targetDepth)) continue;
                platformBuilder.arn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (PlatformBuilder)platformBuilder.build();
    }

    public static PlatformBuilderUnmarshaller getInstance() {
        return INSTANCE;
    }
}

