/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreatePlatformVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.S3Location;

public class CreatePlatformVersionRequestMarshaller
implements Marshaller<Request<CreatePlatformVersionRequest>, CreatePlatformVersionRequest> {
    public Request<CreatePlatformVersionRequest> marshall(CreatePlatformVersionRequest createPlatformVersionRequest) {
        S3Location platformDefinitionBundle;
        if (createPlatformVersionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createPlatformVersionRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "CreatePlatformVersion");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createPlatformVersionRequest.platformName() != null) {
            request.addParameter("PlatformName", StringConversion.fromString((String)createPlatformVersionRequest.platformName()));
        }
        if (createPlatformVersionRequest.platformVersion() != null) {
            request.addParameter("PlatformVersion", StringConversion.fromString((String)createPlatformVersionRequest.platformVersion()));
        }
        if ((platformDefinitionBundle = createPlatformVersionRequest.platformDefinitionBundle()) != null) {
            if (platformDefinitionBundle.s3Bucket() != null) {
                request.addParameter("PlatformDefinitionBundle.S3Bucket", StringConversion.fromString((String)platformDefinitionBundle.s3Bucket()));
            }
            if (platformDefinitionBundle.s3Key() != null) {
                request.addParameter("PlatformDefinitionBundle.S3Key", StringConversion.fromString((String)platformDefinitionBundle.s3Key()));
            }
        }
        if (createPlatformVersionRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringConversion.fromString((String)createPlatformVersionRequest.environmentName()));
        }
        if (createPlatformVersionRequest.optionSettings().isEmpty() && !(createPlatformVersionRequest.optionSettings() instanceof SdkAutoConstructList)) {
            request.addParameter("OptionSettings", "");
        } else if (!createPlatformVersionRequest.optionSettings().isEmpty() && !(createPlatformVersionRequest.optionSettings() instanceof SdkAutoConstructList)) {
            List<ConfigurationOptionSetting> optionSettingsList = createPlatformVersionRequest.optionSettings();
            int optionSettingsListIndex = 1;
            for (ConfigurationOptionSetting optionSettingsListValue : optionSettingsList) {
                if (optionSettingsListValue.resourceName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".ResourceName", StringConversion.fromString((String)optionSettingsListValue.resourceName()));
                }
                if (optionSettingsListValue.namespace() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Namespace", StringConversion.fromString((String)optionSettingsListValue.namespace()));
                }
                if (optionSettingsListValue.optionName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".OptionName", StringConversion.fromString((String)optionSettingsListValue.optionName()));
                }
                if (optionSettingsListValue.value() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Value", StringConversion.fromString((String)optionSettingsListValue.value()));
                }
                ++optionSettingsListIndex;
            }
        }
        return request;
    }
}

