/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateEnvironmentRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentTier;
import software.amazon.awssdk.services.elasticbeanstalk.model.OptionSpecification;
import software.amazon.awssdk.services.elasticbeanstalk.model.Tag;

public class CreateEnvironmentRequestMarshaller
implements Marshaller<Request<CreateEnvironmentRequest>, CreateEnvironmentRequest> {
    public Request<CreateEnvironmentRequest> marshall(CreateEnvironmentRequest createEnvironmentRequest) {
        EnvironmentTier tier;
        if (createEnvironmentRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createEnvironmentRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "CreateEnvironment");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createEnvironmentRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringConversion.fromString((String)createEnvironmentRequest.applicationName()));
        }
        if (createEnvironmentRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringConversion.fromString((String)createEnvironmentRequest.environmentName()));
        }
        if (createEnvironmentRequest.groupName() != null) {
            request.addParameter("GroupName", StringConversion.fromString((String)createEnvironmentRequest.groupName()));
        }
        if (createEnvironmentRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)createEnvironmentRequest.description()));
        }
        if (createEnvironmentRequest.cnamePrefix() != null) {
            request.addParameter("CNAMEPrefix", StringConversion.fromString((String)createEnvironmentRequest.cnamePrefix()));
        }
        if ((tier = createEnvironmentRequest.tier()) != null) {
            if (tier.name() != null) {
                request.addParameter("Tier.Name", StringConversion.fromString((String)tier.name()));
            }
            if (tier.type() != null) {
                request.addParameter("Tier.Type", StringConversion.fromString((String)tier.type()));
            }
            if (tier.version() != null) {
                request.addParameter("Tier.Version", StringConversion.fromString((String)tier.version()));
            }
        }
        if (createEnvironmentRequest.tags().isEmpty() && !(createEnvironmentRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createEnvironmentRequest.tags().isEmpty() && !(createEnvironmentRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = createEnvironmentRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (createEnvironmentRequest.versionLabel() != null) {
            request.addParameter("VersionLabel", StringConversion.fromString((String)createEnvironmentRequest.versionLabel()));
        }
        if (createEnvironmentRequest.templateName() != null) {
            request.addParameter("TemplateName", StringConversion.fromString((String)createEnvironmentRequest.templateName()));
        }
        if (createEnvironmentRequest.solutionStackName() != null) {
            request.addParameter("SolutionStackName", StringConversion.fromString((String)createEnvironmentRequest.solutionStackName()));
        }
        if (createEnvironmentRequest.platformArn() != null) {
            request.addParameter("PlatformArn", StringConversion.fromString((String)createEnvironmentRequest.platformArn()));
        }
        if (createEnvironmentRequest.optionSettings().isEmpty() && !(createEnvironmentRequest.optionSettings() instanceof SdkAutoConstructList)) {
            request.addParameter("OptionSettings", "");
        } else if (!createEnvironmentRequest.optionSettings().isEmpty() && !(createEnvironmentRequest.optionSettings() instanceof SdkAutoConstructList)) {
            List<ConfigurationOptionSetting> optionSettingsList = createEnvironmentRequest.optionSettings();
            int optionSettingsListIndex = 1;
            for (ConfigurationOptionSetting optionSettingsListValue : optionSettingsList) {
                if (optionSettingsListValue.resourceName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".ResourceName", StringConversion.fromString((String)optionSettingsListValue.resourceName()));
                }
                if (optionSettingsListValue.namespace() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Namespace", StringConversion.fromString((String)optionSettingsListValue.namespace()));
                }
                if (optionSettingsListValue.optionName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".OptionName", StringConversion.fromString((String)optionSettingsListValue.optionName()));
                }
                if (optionSettingsListValue.value() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Value", StringConversion.fromString((String)optionSettingsListValue.value()));
                }
                ++optionSettingsListIndex;
            }
        }
        if (createEnvironmentRequest.optionsToRemove().isEmpty() && !(createEnvironmentRequest.optionsToRemove() instanceof SdkAutoConstructList)) {
            request.addParameter("OptionsToRemove", "");
        } else if (!createEnvironmentRequest.optionsToRemove().isEmpty() && !(createEnvironmentRequest.optionsToRemove() instanceof SdkAutoConstructList)) {
            List<OptionSpecification> optionsToRemoveList = createEnvironmentRequest.optionsToRemove();
            int optionsToRemoveListIndex = 1;
            for (OptionSpecification optionsToRemoveListValue : optionsToRemoveList) {
                if (optionsToRemoveListValue.resourceName() != null) {
                    request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex + ".ResourceName", StringConversion.fromString((String)optionsToRemoveListValue.resourceName()));
                }
                if (optionsToRemoveListValue.namespace() != null) {
                    request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex + ".Namespace", StringConversion.fromString((String)optionsToRemoveListValue.namespace()));
                }
                if (optionsToRemoveListValue.optionName() != null) {
                    request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex + ".OptionName", StringConversion.fromString((String)optionsToRemoveListValue.optionName()));
                }
                ++optionsToRemoveListIndex;
            }
        }
        return request;
    }
}

