/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.SourceConfiguration;

public class CreateConfigurationTemplateRequestMarshaller
implements Marshaller<Request<CreateConfigurationTemplateRequest>, CreateConfigurationTemplateRequest> {
    public Request<CreateConfigurationTemplateRequest> marshall(CreateConfigurationTemplateRequest createConfigurationTemplateRequest) {
        SourceConfiguration sourceConfiguration;
        if (createConfigurationTemplateRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createConfigurationTemplateRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "CreateConfigurationTemplate");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createConfigurationTemplateRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringConversion.fromString((String)createConfigurationTemplateRequest.applicationName()));
        }
        if (createConfigurationTemplateRequest.templateName() != null) {
            request.addParameter("TemplateName", StringConversion.fromString((String)createConfigurationTemplateRequest.templateName()));
        }
        if (createConfigurationTemplateRequest.solutionStackName() != null) {
            request.addParameter("SolutionStackName", StringConversion.fromString((String)createConfigurationTemplateRequest.solutionStackName()));
        }
        if (createConfigurationTemplateRequest.platformArn() != null) {
            request.addParameter("PlatformArn", StringConversion.fromString((String)createConfigurationTemplateRequest.platformArn()));
        }
        if ((sourceConfiguration = createConfigurationTemplateRequest.sourceConfiguration()) != null) {
            if (sourceConfiguration.applicationName() != null) {
                request.addParameter("SourceConfiguration.ApplicationName", StringConversion.fromString((String)sourceConfiguration.applicationName()));
            }
            if (sourceConfiguration.templateName() != null) {
                request.addParameter("SourceConfiguration.TemplateName", StringConversion.fromString((String)sourceConfiguration.templateName()));
            }
        }
        if (createConfigurationTemplateRequest.environmentId() != null) {
            request.addParameter("EnvironmentId", StringConversion.fromString((String)createConfigurationTemplateRequest.environmentId()));
        }
        if (createConfigurationTemplateRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)createConfigurationTemplateRequest.description()));
        }
        if (createConfigurationTemplateRequest.optionSettings().isEmpty() && !(createConfigurationTemplateRequest.optionSettings() instanceof SdkAutoConstructList)) {
            request.addParameter("OptionSettings", "");
        } else if (!createConfigurationTemplateRequest.optionSettings().isEmpty() && !(createConfigurationTemplateRequest.optionSettings() instanceof SdkAutoConstructList)) {
            List<ConfigurationOptionSetting> optionSettingsList = createConfigurationTemplateRequest.optionSettings();
            int optionSettingsListIndex = 1;
            for (ConfigurationOptionSetting optionSettingsListValue : optionSettingsList) {
                if (optionSettingsListValue.resourceName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".ResourceName", StringConversion.fromString((String)optionSettingsListValue.resourceName()));
                }
                if (optionSettingsListValue.namespace() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Namespace", StringConversion.fromString((String)optionSettingsListValue.namespace()));
                }
                if (optionSettingsListValue.optionName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".OptionName", StringConversion.fromString((String)optionSettingsListValue.optionName()));
                }
                if (optionSettingsListValue.value() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Value", StringConversion.fromString((String)optionSettingsListValue.value()));
                }
                ++optionSettingsListIndex;
            }
        }
        return request;
    }
}

