/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.CheckDnsAvailabilityRequest;

public class CheckDnsAvailabilityRequestMarshaller
implements Marshaller<Request<CheckDnsAvailabilityRequest>, CheckDnsAvailabilityRequest> {
    public Request<CheckDnsAvailabilityRequest> marshall(CheckDnsAvailabilityRequest checkDnsAvailabilityRequest) {
        if (checkDnsAvailabilityRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)checkDnsAvailabilityRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "CheckDNSAvailability");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (checkDnsAvailabilityRequest.cnamePrefix() != null) {
            request.addParameter("CNAMEPrefix", StringConversion.fromString((String)checkDnsAvailabilityRequest.cnamePrefix()));
        }
        return request;
    }
}

