/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.S3Location;

public class S3LocationUnmarshaller
implements Unmarshaller<S3Location, StaxUnmarshallerContext> {
    private static final S3LocationUnmarshaller INSTANCE = new S3LocationUnmarshaller();

    public S3Location unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        S3Location.Builder s3Location = S3Location.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("S3Bucket", targetDepth)) {
                    s3Location.s3Bucket(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("S3Key", targetDepth)) continue;
                s3Location.s3Key(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (S3Location)s3Location.build();
    }

    public static S3LocationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

