/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationsRequest;

public class DescribeApplicationsRequestMarshaller
implements Marshaller<Request<DescribeApplicationsRequest>, DescribeApplicationsRequest> {
    public Request<DescribeApplicationsRequest> marshall(DescribeApplicationsRequest describeApplicationsRequest) {
        if (describeApplicationsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeApplicationsRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DescribeApplications");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeApplicationsRequest.applicationNames().isEmpty() && !(describeApplicationsRequest.applicationNames() instanceof SdkAutoConstructList)) {
            request.addParameter("ApplicationNames", "");
        } else if (!describeApplicationsRequest.applicationNames().isEmpty() && !(describeApplicationsRequest.applicationNames() instanceof SdkAutoConstructList)) {
            List<String> applicationNamesList = describeApplicationsRequest.applicationNames();
            int applicationNamesListIndex = 1;
            for (String applicationNamesListValue : applicationNamesList) {
                if (applicationNamesListValue != null) {
                    request.addParameter("ApplicationNames.member." + applicationNamesListIndex, StringConversion.fromString((String)applicationNamesListValue));
                }
                ++applicationNamesListIndex;
            }
        }
        return request;
    }
}

