/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationVersionRequest;

public class DeleteApplicationVersionRequestMarshaller
implements Marshaller<Request<DeleteApplicationVersionRequest>, DeleteApplicationVersionRequest> {
    public Request<DeleteApplicationVersionRequest> marshall(DeleteApplicationVersionRequest deleteApplicationVersionRequest) {
        if (deleteApplicationVersionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteApplicationVersionRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DeleteApplicationVersion");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteApplicationVersionRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringConversion.fromString((String)deleteApplicationVersionRequest.applicationName()));
        }
        if (deleteApplicationVersionRequest.versionLabel() != null) {
            request.addParameter("VersionLabel", StringConversion.fromString((String)deleteApplicationVersionRequest.versionLabel()));
        }
        if (deleteApplicationVersionRequest.deleteSourceBundle() != null) {
            request.addParameter("DeleteSourceBundle", StringConversion.fromBoolean((Boolean)deleteApplicationVersionRequest.deleteSourceBundle()));
        }
        return request;
    }
}

