/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.elasticbeanstalk.model.ActionStatus;
import software.amazon.awssdk.services.elasticbeanstalk.model.ActionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedAction
implements ToCopyableBuilder<Builder, ManagedAction> {
    private final String actionId;
    private final String actionDescription;
    private final String actionType;
    private final String status;
    private final Instant windowStartTime;

    private ManagedAction(BuilderImpl builder) {
        this.actionId = builder.actionId;
        this.actionDescription = builder.actionDescription;
        this.actionType = builder.actionType;
        this.status = builder.status;
        this.windowStartTime = builder.windowStartTime;
    }

    public String actionId() {
        return this.actionId;
    }

    public String actionDescription() {
        return this.actionDescription;
    }

    public ActionType actionType() {
        return ActionType.fromValue(this.actionType);
    }

    public String actionTypeAsString() {
        return this.actionType;
    }

    public ActionStatus status() {
        return ActionStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant windowStartTime() {
        return this.windowStartTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.windowStartTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedAction)) {
            return false;
        }
        ManagedAction other = (ManagedAction)obj;
        return Objects.equals(this.actionId(), other.actionId()) && Objects.equals(this.actionDescription(), other.actionDescription()) && Objects.equals(this.actionTypeAsString(), other.actionTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.windowStartTime(), other.windowStartTime());
    }

    public String toString() {
        return ToString.builder((String)"ManagedAction").add("ActionId", (Object)this.actionId()).add("ActionDescription", (Object)this.actionDescription()).add("ActionType", (Object)this.actionTypeAsString()).add("Status", (Object)this.statusAsString()).add("WindowStartTime", (Object)this.windowStartTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionId": {
                return Optional.ofNullable(clazz.cast(this.actionId()));
            }
            case "ActionDescription": {
                return Optional.ofNullable(clazz.cast(this.actionDescription()));
            }
            case "ActionType": {
                return Optional.ofNullable(clazz.cast(this.actionTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "WindowStartTime": {
                return Optional.ofNullable(clazz.cast(this.windowStartTime()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String actionId;
        private String actionDescription;
        private String actionType;
        private String status;
        private Instant windowStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedAction model) {
            this.actionId(model.actionId);
            this.actionDescription(model.actionDescription);
            this.actionType(model.actionType);
            this.status(model.status);
            this.windowStartTime(model.windowStartTime);
        }

        public final String getActionId() {
            return this.actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        public final String getActionDescription() {
            return this.actionDescription;
        }

        @Override
        public final Builder actionDescription(String actionDescription) {
            this.actionDescription = actionDescription;
            return this;
        }

        public final void setActionDescription(String actionDescription) {
            this.actionDescription = actionDescription;
        }

        public final String getActionType() {
            return this.actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType.toString());
            return this;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ActionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getWindowStartTime() {
            return this.windowStartTime;
        }

        @Override
        public final Builder windowStartTime(Instant windowStartTime) {
            this.windowStartTime = windowStartTime;
            return this;
        }

        public final void setWindowStartTime(Instant windowStartTime) {
            this.windowStartTime = windowStartTime;
        }

        public ManagedAction build() {
            return new ManagedAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ManagedAction> {
        public Builder actionId(String var1);

        public Builder actionDescription(String var1);

        public Builder actionType(String var1);

        public Builder actionType(ActionType var1);

        public Builder status(String var1);

        public Builder status(ActionStatus var1);

        public Builder windowStartTime(Instant var1);
    }
}

