/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformFilter;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPlatformVersionsRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, ListPlatformVersionsRequest> {
    private final List<PlatformFilter> filters;
    private final Integer maxRecords;
    private final String nextToken;

    private ListPlatformVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.nextToken = builder.nextToken;
    }

    public List<PlatformFilter> filters() {
        return this.filters;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPlatformVersionsRequest)) {
            return false;
        }
        ListPlatformVersionsRequest other = (ListPlatformVersionsRequest)((Object)obj);
        return Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListPlatformVersionsRequest").add("Filters", this.filters()).add("MaxRecords", (Object)this.maxRecords()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private List<PlatformFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxRecords;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPlatformVersionsRequest model) {
            super(model);
            this.filters(model.filters);
            this.maxRecords(model.maxRecords);
            this.nextToken(model.nextToken);
        }

        public final Collection<PlatformFilter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(PlatformFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<PlatformFilter> filters) {
            this.filters = PlatformFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(PlatformFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<PlatformFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (PlatformFilter)((PlatformFilter.Builder)PlatformFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<PlatformFilter.BuilderImpl> filters) {
            this.filters = PlatformFiltersCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPlatformVersionsRequest build() {
            return new ListPlatformVersionsRequest(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    CopyableBuilder<Builder, ListPlatformVersionsRequest> {
        public Builder filters(Collection<PlatformFilter> var1);

        public Builder filters(PlatformFilter ... var1);

        public Builder filters(Consumer<PlatformFilter.Builder> ... var1);

        public Builder maxRecords(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

