/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationTemplateNamesListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.VersionLabelsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationDescription
implements ToCopyableBuilder<Builder, ApplicationDescription> {
    private final String applicationName;
    private final String description;
    private final Instant dateCreated;
    private final Instant dateUpdated;
    private final List<String> versions;
    private final List<String> configurationTemplates;
    private final ApplicationResourceLifecycleConfig resourceLifecycleConfig;

    private ApplicationDescription(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.description = builder.description;
        this.dateCreated = builder.dateCreated;
        this.dateUpdated = builder.dateUpdated;
        this.versions = builder.versions;
        this.configurationTemplates = builder.configurationTemplates;
        this.resourceLifecycleConfig = builder.resourceLifecycleConfig;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String description() {
        return this.description;
    }

    public Instant dateCreated() {
        return this.dateCreated;
    }

    public Instant dateUpdated() {
        return this.dateUpdated;
    }

    public List<String> versions() {
        return this.versions;
    }

    public List<String> configurationTemplates() {
        return this.configurationTemplates;
    }

    public ApplicationResourceLifecycleConfig resourceLifecycleConfig() {
        return this.resourceLifecycleConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.versions());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationTemplates());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceLifecycleConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationDescription)) {
            return false;
        }
        ApplicationDescription other = (ApplicationDescription)obj;
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.dateCreated(), other.dateCreated()) && Objects.equals(this.dateUpdated(), other.dateUpdated()) && Objects.equals(this.versions(), other.versions()) && Objects.equals(this.configurationTemplates(), other.configurationTemplates()) && Objects.equals(this.resourceLifecycleConfig(), other.resourceLifecycleConfig());
    }

    public String toString() {
        return ToString.builder((String)"ApplicationDescription").add("ApplicationName", (Object)this.applicationName()).add("Description", (Object)this.description()).add("DateCreated", (Object)this.dateCreated()).add("DateUpdated", (Object)this.dateUpdated()).add("Versions", this.versions()).add("ConfigurationTemplates", this.configurationTemplates()).add("ResourceLifecycleConfig", (Object)this.resourceLifecycleConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DateCreated": {
                return Optional.ofNullable(clazz.cast(this.dateCreated()));
            }
            case "DateUpdated": {
                return Optional.ofNullable(clazz.cast(this.dateUpdated()));
            }
            case "Versions": {
                return Optional.ofNullable(clazz.cast(this.versions()));
            }
            case "ConfigurationTemplates": {
                return Optional.ofNullable(clazz.cast(this.configurationTemplates()));
            }
            case "ResourceLifecycleConfig": {
                return Optional.ofNullable(clazz.cast(this.resourceLifecycleConfig()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String description;
        private Instant dateCreated;
        private Instant dateUpdated;
        private List<String> versions = DefaultSdkAutoConstructList.getInstance();
        private List<String> configurationTemplates = DefaultSdkAutoConstructList.getInstance();
        private ApplicationResourceLifecycleConfig resourceLifecycleConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationDescription model) {
            this.applicationName(model.applicationName);
            this.description(model.description);
            this.dateCreated(model.dateCreated);
            this.dateUpdated(model.dateUpdated);
            this.versions(model.versions);
            this.configurationTemplates(model.configurationTemplates);
            this.resourceLifecycleConfig(model.resourceLifecycleConfig);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getDateCreated() {
            return this.dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        public final Instant getDateUpdated() {
            return this.dateUpdated;
        }

        @Override
        public final Builder dateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public final void setDateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
        }

        public final Collection<String> getVersions() {
            return this.versions;
        }

        @Override
        public final Builder versions(Collection<String> versions) {
            this.versions = VersionLabelsListCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(String ... versions) {
            this.versions(Arrays.asList(versions));
            return this;
        }

        public final void setVersions(Collection<String> versions) {
            this.versions = VersionLabelsListCopier.copy(versions);
        }

        public final Collection<String> getConfigurationTemplates() {
            return this.configurationTemplates;
        }

        @Override
        public final Builder configurationTemplates(Collection<String> configurationTemplates) {
            this.configurationTemplates = ConfigurationTemplateNamesListCopier.copy(configurationTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationTemplates(String ... configurationTemplates) {
            this.configurationTemplates(Arrays.asList(configurationTemplates));
            return this;
        }

        public final void setConfigurationTemplates(Collection<String> configurationTemplates) {
            this.configurationTemplates = ConfigurationTemplateNamesListCopier.copy(configurationTemplates);
        }

        public final ApplicationResourceLifecycleConfig.Builder getResourceLifecycleConfig() {
            return this.resourceLifecycleConfig != null ? this.resourceLifecycleConfig.toBuilder() : null;
        }

        @Override
        public final Builder resourceLifecycleConfig(ApplicationResourceLifecycleConfig resourceLifecycleConfig) {
            this.resourceLifecycleConfig = resourceLifecycleConfig;
            return this;
        }

        public final void setResourceLifecycleConfig(ApplicationResourceLifecycleConfig.BuilderImpl resourceLifecycleConfig) {
            this.resourceLifecycleConfig = resourceLifecycleConfig != null ? resourceLifecycleConfig.build() : null;
        }

        public ApplicationDescription build() {
            return new ApplicationDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ApplicationDescription> {
        public Builder applicationName(String var1);

        public Builder description(String var1);

        public Builder dateCreated(Instant var1);

        public Builder dateUpdated(Instant var1);

        public Builder versions(Collection<String> var1);

        public Builder versions(String ... var1);

        public Builder configurationTemplates(Collection<String> var1);

        public Builder configurationTemplates(String ... var1);

        public Builder resourceLifecycleConfig(ApplicationResourceLifecycleConfig var1);

        default public Builder resourceLifecycleConfig(Consumer<ApplicationResourceLifecycleConfig.Builder> resourceLifecycleConfig) {
            return this.resourceLifecycleConfig((ApplicationResourceLifecycleConfig)((ApplicationResourceLifecycleConfig.Builder)ApplicationResourceLifecycleConfig.builder().applyMutation(resourceLifecycleConfig)).build());
        }
    }
}

