/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import software.amazon.awssdk.services.elasticbeanstalk.model.OptionSpecification;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest;

public class UpdateConfigurationTemplateRequestMarshaller
implements Marshaller<Request<UpdateConfigurationTemplateRequest>, UpdateConfigurationTemplateRequest> {
    public Request<UpdateConfigurationTemplateRequest> marshall(UpdateConfigurationTemplateRequest updateConfigurationTemplateRequest) {
        List<OptionSpecification> optionsToRemoveList;
        List<ConfigurationOptionSetting> optionSettingsList;
        if (updateConfigurationTemplateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)updateConfigurationTemplateRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "UpdateConfigurationTemplate");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateConfigurationTemplateRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)updateConfigurationTemplateRequest.applicationName()));
        }
        if (updateConfigurationTemplateRequest.templateName() != null) {
            request.addParameter("TemplateName", StringUtils.fromString((String)updateConfigurationTemplateRequest.templateName()));
        }
        if (updateConfigurationTemplateRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)updateConfigurationTemplateRequest.description()));
        }
        if ((optionSettingsList = updateConfigurationTemplateRequest.optionSettings()) != null) {
            if (!optionSettingsList.isEmpty()) {
                int optionSettingsListIndex = 1;
                for (ConfigurationOptionSetting optionSettingsListValue : optionSettingsList) {
                    if (optionSettingsListValue.resourceName() != null) {
                        request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".ResourceName", StringUtils.fromString((String)optionSettingsListValue.resourceName()));
                    }
                    if (optionSettingsListValue.namespace() != null) {
                        request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Namespace", StringUtils.fromString((String)optionSettingsListValue.namespace()));
                    }
                    if (optionSettingsListValue.optionName() != null) {
                        request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".OptionName", StringUtils.fromString((String)optionSettingsListValue.optionName()));
                    }
                    if (optionSettingsListValue.value() != null) {
                        request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Value", StringUtils.fromString((String)optionSettingsListValue.value()));
                    }
                    ++optionSettingsListIndex;
                }
            } else {
                request.addParameter("OptionSettings", "");
            }
        }
        if ((optionsToRemoveList = updateConfigurationTemplateRequest.optionsToRemove()) != null) {
            if (!optionsToRemoveList.isEmpty()) {
                int optionsToRemoveListIndex = 1;
                for (OptionSpecification optionsToRemoveListValue : optionsToRemoveList) {
                    if (optionsToRemoveListValue.resourceName() != null) {
                        request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex + ".ResourceName", StringUtils.fromString((String)optionsToRemoveListValue.resourceName()));
                    }
                    if (optionsToRemoveListValue.namespace() != null) {
                        request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex + ".Namespace", StringUtils.fromString((String)optionsToRemoveListValue.namespace()));
                    }
                    if (optionsToRemoveListValue.optionName() != null) {
                        request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex + ".OptionName", StringUtils.fromString((String)optionsToRemoveListValue.optionName()));
                    }
                    ++optionsToRemoveListIndex;
                }
            } else {
                request.addParameter("OptionsToRemove", "");
            }
        }
        return request;
    }
}

