/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.SourceBuildInformation;

public class SourceBuildInformationUnmarshaller
implements Unmarshaller<SourceBuildInformation, StaxUnmarshallerContext> {
    private static final SourceBuildInformationUnmarshaller INSTANCE = new SourceBuildInformationUnmarshaller();

    public SourceBuildInformation unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        SourceBuildInformation.Builder sourceBuildInformation = SourceBuildInformation.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("SourceType", targetDepth)) {
                    sourceBuildInformation.sourceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SourceRepository", targetDepth)) {
                    sourceBuildInformation.sourceRepository(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("SourceLocation", targetDepth)) continue;
                sourceBuildInformation.sourceLocation(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (SourceBuildInformation)sourceBuildInformation.build();
    }

    public static SourceBuildInformationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

