/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.InstanceHealthSummary;

public class InstanceHealthSummaryUnmarshaller
implements Unmarshaller<InstanceHealthSummary, StaxUnmarshallerContext> {
    private static final InstanceHealthSummaryUnmarshaller INSTANCE = new InstanceHealthSummaryUnmarshaller();

    public InstanceHealthSummary unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        InstanceHealthSummary.Builder instanceHealthSummary = InstanceHealthSummary.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("NoData", targetDepth)) {
                    instanceHealthSummary.noData(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Unknown", targetDepth)) {
                    instanceHealthSummary.unknown(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Pending", targetDepth)) {
                    instanceHealthSummary.pending(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Ok", targetDepth)) {
                    instanceHealthSummary.ok(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Info", targetDepth)) {
                    instanceHealthSummary.info(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Warning", targetDepth)) {
                    instanceHealthSummary.warning(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Degraded", targetDepth)) {
                    instanceHealthSummary.degraded(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Severe", targetDepth)) continue;
                instanceHealthSummary.severe(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (InstanceHealthSummary)instanceHealthSummary.build();
    }

    public static InstanceHealthSummaryUnmarshaller getInstance() {
        return INSTANCE;
    }
}

