/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeInstancesHealthRequest;

public class DescribeInstancesHealthRequestMarshaller
implements Marshaller<Request<DescribeInstancesHealthRequest>, DescribeInstancesHealthRequest> {
    public Request<DescribeInstancesHealthRequest> marshall(DescribeInstancesHealthRequest describeInstancesHealthRequest) {
        List<String> attributeNamesList;
        if (describeInstancesHealthRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeInstancesHealthRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DescribeInstancesHealth");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeInstancesHealthRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)describeInstancesHealthRequest.environmentName()));
        }
        if (describeInstancesHealthRequest.environmentId() != null) {
            request.addParameter("EnvironmentId", StringUtils.fromString((String)describeInstancesHealthRequest.environmentId()));
        }
        if ((attributeNamesList = describeInstancesHealthRequest.attributeNamesAsStrings()) != null) {
            if (!attributeNamesList.isEmpty()) {
                int attributeNamesListIndex = 1;
                for (String attributeNamesListValue : attributeNamesList) {
                    if (attributeNamesListValue != null) {
                        request.addParameter("AttributeNames.member." + attributeNamesListIndex, StringUtils.fromString((String)attributeNamesListValue));
                    }
                    ++attributeNamesListIndex;
                }
            } else {
                request.addParameter("AttributeNames", "");
            }
        }
        if (describeInstancesHealthRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeInstancesHealthRequest.nextToken()));
        }
        return request;
    }
}

