/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentHealthRequest;

public class DescribeEnvironmentHealthRequestMarshaller
implements Marshaller<Request<DescribeEnvironmentHealthRequest>, DescribeEnvironmentHealthRequest> {
    public Request<DescribeEnvironmentHealthRequest> marshall(DescribeEnvironmentHealthRequest describeEnvironmentHealthRequest) {
        List<String> attributeNamesList;
        if (describeEnvironmentHealthRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeEnvironmentHealthRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DescribeEnvironmentHealth");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeEnvironmentHealthRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)describeEnvironmentHealthRequest.environmentName()));
        }
        if (describeEnvironmentHealthRequest.environmentId() != null) {
            request.addParameter("EnvironmentId", StringUtils.fromString((String)describeEnvironmentHealthRequest.environmentId()));
        }
        if ((attributeNamesList = describeEnvironmentHealthRequest.attributeNamesAsStrings()) != null) {
            if (!attributeNamesList.isEmpty()) {
                int attributeNamesListIndex = 1;
                for (String attributeNamesListValue : attributeNamesList) {
                    if (attributeNamesListValue != null) {
                        request.addParameter("AttributeNames.member." + attributeNamesListIndex, StringUtils.fromString((String)attributeNamesListValue));
                    }
                    ++attributeNamesListIndex;
                }
            } else {
                request.addParameter("AttributeNames", "");
            }
        }
        return request;
    }
}

