/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.BuildConfiguration;

public class BuildConfigurationUnmarshaller
implements Unmarshaller<BuildConfiguration, StaxUnmarshallerContext> {
    private static final BuildConfigurationUnmarshaller INSTANCE = new BuildConfigurationUnmarshaller();

    public BuildConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        BuildConfiguration.Builder buildConfiguration = BuildConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ArtifactName", targetDepth)) {
                    buildConfiguration.artifactName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CodeBuildServiceRole", targetDepth)) {
                    buildConfiguration.codeBuildServiceRole(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ComputeType", targetDepth)) {
                    buildConfiguration.computeType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Image", targetDepth)) {
                    buildConfiguration.image(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("TimeoutInMinutes", targetDepth)) continue;
                buildConfiguration.timeoutInMinutes(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (BuildConfiguration)buildConfiguration.build();
    }

    public static BuildConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

