/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformFilterValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PlatformFilter
implements ToCopyableBuilder<Builder, PlatformFilter> {
    private final String type;
    private final String operator;
    private final List<String> values;

    private PlatformFilter(BuilderImpl builder) {
        this.type = builder.type;
        this.operator = builder.operator;
        this.values = builder.values;
    }

    public String type() {
        return this.type;
    }

    public String operator() {
        return this.operator;
    }

    public List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.operator());
        hashCode = 31 * hashCode + Objects.hashCode(this.values());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlatformFilter)) {
            return false;
        }
        PlatformFilter other = (PlatformFilter)obj;
        return Objects.equals(this.type(), other.type()) && Objects.equals(this.operator(), other.operator()) && Objects.equals(this.values(), other.values());
    }

    public String toString() {
        return ToString.builder((String)"PlatformFilter").add("Type", (Object)this.type()).add("Operator", (Object)this.operator()).add("Values", this.values()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.of(clazz.cast(this.type()));
            }
            case "Operator": {
                return Optional.of(clazz.cast(this.operator()));
            }
            case "Values": {
                return Optional.of(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String operator;
        private List<String> values;

        private BuilderImpl() {
        }

        private BuilderImpl(PlatformFilter model) {
            this.type(model.type);
            this.operator(model.operator);
            this.values(model.values);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getOperator() {
            return this.operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        public final Collection<String> getValues() {
            return this.values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = PlatformFilterValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = PlatformFilterValueListCopier.copy(values);
        }

        public PlatformFilter build() {
            return new PlatformFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PlatformFilter> {
        public Builder type(String var1);

        public Builder operator(String var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

