/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.InstanceHealthListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.SingleInstanceHealth;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInstancesHealthResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, DescribeInstancesHealthResponse> {
    private final List<SingleInstanceHealth> instanceHealthList;
    private final Instant refreshedAt;
    private final String nextToken;

    private DescribeInstancesHealthResponse(BuilderImpl builder) {
        super(builder);
        this.instanceHealthList = builder.instanceHealthList;
        this.refreshedAt = builder.refreshedAt;
        this.nextToken = builder.nextToken;
    }

    public List<SingleInstanceHealth> instanceHealthList() {
        return this.instanceHealthList;
    }

    public Instant refreshedAt() {
        return this.refreshedAt;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceHealthList());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancesHealthResponse)) {
            return false;
        }
        DescribeInstancesHealthResponse other = (DescribeInstancesHealthResponse)((Object)obj);
        return Objects.equals(this.instanceHealthList(), other.instanceHealthList()) && Objects.equals(this.refreshedAt(), other.refreshedAt()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeInstancesHealthResponse").add("InstanceHealthList", this.instanceHealthList()).add("RefreshedAt", (Object)this.refreshedAt()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceHealthList": {
                return Optional.of(clazz.cast(this.instanceHealthList()));
            }
            case "RefreshedAt": {
                return Optional.of(clazz.cast(this.refreshedAt()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private List<SingleInstanceHealth> instanceHealthList;
        private Instant refreshedAt;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancesHealthResponse model) {
            super(model);
            this.instanceHealthList(model.instanceHealthList);
            this.refreshedAt(model.refreshedAt);
            this.nextToken(model.nextToken);
        }

        public final Collection<SingleInstanceHealth.Builder> getInstanceHealthList() {
            return this.instanceHealthList != null ? (Collection)this.instanceHealthList.stream().map(SingleInstanceHealth::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceHealthList(Collection<SingleInstanceHealth> instanceHealthList) {
            this.instanceHealthList = InstanceHealthListCopier.copy(instanceHealthList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceHealthList(SingleInstanceHealth ... instanceHealthList) {
            this.instanceHealthList(Arrays.asList(instanceHealthList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceHealthList(Consumer<SingleInstanceHealth.Builder> ... instanceHealthList) {
            this.instanceHealthList(Stream.of(instanceHealthList).map(c -> (SingleInstanceHealth)((SingleInstanceHealth.Builder)SingleInstanceHealth.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceHealthList(Collection<SingleInstanceHealth.BuilderImpl> instanceHealthList) {
            this.instanceHealthList = InstanceHealthListCopier.copyFromBuilder(instanceHealthList);
        }

        public final Instant getRefreshedAt() {
            return this.refreshedAt;
        }

        @Override
        public final Builder refreshedAt(Instant refreshedAt) {
            this.refreshedAt = refreshedAt;
            return this;
        }

        public final void setRefreshedAt(Instant refreshedAt) {
            this.refreshedAt = refreshedAt;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInstancesHealthResponse build() {
            return new DescribeInstancesHealthResponse(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    CopyableBuilder<Builder, DescribeInstancesHealthResponse> {
        public Builder instanceHealthList(Collection<SingleInstanceHealth> var1);

        public Builder instanceHealthList(SingleInstanceHealth ... var1);

        public Builder instanceHealthList(Consumer<SingleInstanceHealth.Builder> ... var1);

        public Builder refreshedAt(Instant var1);

        public Builder nextToken(String var1);
    }
}

