/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute;
import software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttributesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInstancesHealthRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, DescribeInstancesHealthRequest> {
    private final String environmentName;
    private final String environmentId;
    private final List<String> attributeNames;
    private final String nextToken;

    private DescribeInstancesHealthRequest(BuilderImpl builder) {
        super(builder);
        this.environmentName = builder.environmentName;
        this.environmentId = builder.environmentId;
        this.attributeNames = builder.attributeNames;
        this.nextToken = builder.nextToken;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public List<InstancesHealthAttribute> attributeNames() {
        return TypeConverter.convert(this.attributeNames, InstancesHealthAttribute::fromValue);
    }

    public List<String> attributeNamesAsStrings() {
        return this.attributeNames;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeNamesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancesHealthRequest)) {
            return false;
        }
        DescribeInstancesHealthRequest other = (DescribeInstancesHealthRequest)((Object)obj);
        return Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.attributeNamesAsStrings(), other.attributeNamesAsStrings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeInstancesHealthRequest").add("EnvironmentName", (Object)this.environmentName()).add("EnvironmentId", (Object)this.environmentId()).add("AttributeNames", this.attributeNamesAsStrings()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnvironmentName": {
                return Optional.of(clazz.cast(this.environmentName()));
            }
            case "EnvironmentId": {
                return Optional.of(clazz.cast(this.environmentId()));
            }
            case "AttributeNames": {
                return Optional.of(clazz.cast(this.attributeNamesAsStrings()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String environmentName;
        private String environmentId;
        private List<String> attributeNames;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancesHealthRequest model) {
            super(model);
            this.environmentName(model.environmentName);
            this.environmentId(model.environmentId);
            this.attributeNames(model.attributeNames);
            this.nextToken(model.nextToken);
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final Collection<String> getAttributeNames() {
            return this.attributeNames;
        }

        @Override
        public final Builder attributeNames(Collection<String> attributeNames) {
            this.attributeNames = InstancesHealthAttributesCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(String ... attributeNames) {
            this.attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = InstancesHealthAttributesCopier.copy(attributeNames);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeInstancesHealthRequest build() {
            return new DescribeInstancesHealthRequest(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    CopyableBuilder<Builder, DescribeInstancesHealthRequest> {
        public Builder environmentName(String var1);

        public Builder environmentId(String var1);

        public Builder attributeNames(Collection<String> var1);

        public Builder attributeNames(String ... var1);

        public Builder nextToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

