/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionDescriptionListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeApplicationVersionsResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, DescribeApplicationVersionsResponse> {
    private final List<ApplicationVersionDescription> applicationVersions;
    private final String nextToken;

    private DescribeApplicationVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationVersions = builder.applicationVersions;
        this.nextToken = builder.nextToken;
    }

    public List<ApplicationVersionDescription> applicationVersions() {
        return this.applicationVersions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationVersionsResponse)) {
            return false;
        }
        DescribeApplicationVersionsResponse other = (DescribeApplicationVersionsResponse)((Object)obj);
        return Objects.equals(this.applicationVersions(), other.applicationVersions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeApplicationVersionsResponse").add("ApplicationVersions", this.applicationVersions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationVersions": {
                return Optional.of(clazz.cast(this.applicationVersions()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private List<ApplicationVersionDescription> applicationVersions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationVersionsResponse model) {
            super(model);
            this.applicationVersions(model.applicationVersions);
            this.nextToken(model.nextToken);
        }

        public final Collection<ApplicationVersionDescription.Builder> getApplicationVersions() {
            return this.applicationVersions != null ? (Collection)this.applicationVersions.stream().map(ApplicationVersionDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder applicationVersions(Collection<ApplicationVersionDescription> applicationVersions) {
            this.applicationVersions = ApplicationVersionDescriptionListCopier.copy(applicationVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationVersions(ApplicationVersionDescription ... applicationVersions) {
            this.applicationVersions(Arrays.asList(applicationVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationVersions(Consumer<ApplicationVersionDescription.Builder> ... applicationVersions) {
            this.applicationVersions(Stream.of(applicationVersions).map(c -> (ApplicationVersionDescription)((ApplicationVersionDescription.Builder)ApplicationVersionDescription.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setApplicationVersions(Collection<ApplicationVersionDescription.BuilderImpl> applicationVersions) {
            this.applicationVersions = ApplicationVersionDescriptionListCopier.copyFromBuilder(applicationVersions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeApplicationVersionsResponse build() {
            return new DescribeApplicationVersionsResponse(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    CopyableBuilder<Builder, DescribeApplicationVersionsResponse> {
        public Builder applicationVersions(Collection<ApplicationVersionDescription> var1);

        public Builder applicationVersions(ApplicationVersionDescription ... var1);

        public Builder applicationVersions(Consumer<ApplicationVersionDescription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

