/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.Date;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeEventsRequestMarshaller
implements Marshaller<Request<DescribeEventsRequest>, DescribeEventsRequest> {
    public Request<DescribeEventsRequest> marshall(DescribeEventsRequest describeEventsRequest) {
        if (describeEventsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeEventsRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DescribeEvents");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeEventsRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)describeEventsRequest.applicationName()));
        }
        if (describeEventsRequest.versionLabel() != null) {
            request.addParameter("VersionLabel", StringUtils.fromString((String)describeEventsRequest.versionLabel()));
        }
        if (describeEventsRequest.templateName() != null) {
            request.addParameter("TemplateName", StringUtils.fromString((String)describeEventsRequest.templateName()));
        }
        if (describeEventsRequest.environmentId() != null) {
            request.addParameter("EnvironmentId", StringUtils.fromString((String)describeEventsRequest.environmentId()));
        }
        if (describeEventsRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)describeEventsRequest.environmentName()));
        }
        if (describeEventsRequest.platformArn() != null) {
            request.addParameter("PlatformArn", StringUtils.fromString((String)describeEventsRequest.platformArn()));
        }
        if (describeEventsRequest.requestId() != null) {
            request.addParameter("RequestId", StringUtils.fromString((String)describeEventsRequest.requestId()));
        }
        if (describeEventsRequest.severity() != null) {
            request.addParameter("Severity", StringUtils.fromString((String)describeEventsRequest.severity()));
        }
        if (describeEventsRequest.startTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate((Date)describeEventsRequest.startTime()));
        }
        if (describeEventsRequest.endTime() != null) {
            request.addParameter("EndTime", StringUtils.fromDate((Date)describeEventsRequest.endTime()));
        }
        if (describeEventsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeEventsRequest.maxRecords()));
        }
        if (describeEventsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeEventsRequest.nextToken()));
        }
        return request;
    }
}

