/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeApplicationVersionsRequestMarshaller
implements Marshaller<Request<DescribeApplicationVersionsRequest>, DescribeApplicationVersionsRequest> {
    public Request<DescribeApplicationVersionsRequest> marshall(DescribeApplicationVersionsRequest describeApplicationVersionsRequest) {
        SdkInternalList versionLabelsList;
        if (describeApplicationVersionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeApplicationVersionsRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DescribeApplicationVersions");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeApplicationVersionsRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)describeApplicationVersionsRequest.applicationName()));
        }
        if (!(versionLabelsList = (SdkInternalList)describeApplicationVersionsRequest.versionLabels()).isEmpty() || !versionLabelsList.isAutoConstruct()) {
            int versionLabelsListIndex = 1;
            for (String versionLabelsListValue : versionLabelsList) {
                if (versionLabelsListValue != null) {
                    request.addParameter("VersionLabels.member." + versionLabelsListIndex, StringUtils.fromString((String)versionLabelsListValue));
                }
                ++versionLabelsListIndex;
            }
        }
        if (describeApplicationVersionsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeApplicationVersionsRequest.maxRecords()));
        }
        if (describeApplicationVersionsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeApplicationVersionsRequest.nextToken()));
        }
        return request;
    }
}

