/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.Deployment;

public class DeploymentUnmarshaller
implements Unmarshaller<Deployment, StaxUnmarshallerContext> {
    private static DeploymentUnmarshaller INSTANCE;

    public Deployment unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Deployment.Builder deployment = Deployment.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("VersionLabel", targetDepth)) {
                    deployment.versionLabel(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DeploymentId", targetDepth)) {
                    deployment.deploymentId(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    deployment.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("DeploymentTime", targetDepth)) continue;
                deployment.deploymentTime(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Deployment)deployment.build();
    }

    public static DeploymentUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DeploymentUnmarshaller();
        }
        return INSTANCE;
    }
}

