/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSettingsListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentTier;
import software.amazon.awssdk.services.elasticbeanstalk.model.OptionSpecification;
import software.amazon.awssdk.services.elasticbeanstalk.model.OptionsSpecifierListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateEnvironmentRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateEnvironmentRequest> {
    private final String applicationName;
    private final String environmentId;
    private final String environmentName;
    private final String groupName;
    private final String description;
    private final EnvironmentTier tier;
    private final String versionLabel;
    private final String templateName;
    private final String solutionStackName;
    private final String platformArn;
    private final List<ConfigurationOptionSetting> optionSettings;
    private final List<OptionSpecification> optionsToRemove;

    private UpdateEnvironmentRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.environmentId = builder.environmentId;
        this.environmentName = builder.environmentName;
        this.groupName = builder.groupName;
        this.description = builder.description;
        this.tier = builder.tier;
        this.versionLabel = builder.versionLabel;
        this.templateName = builder.templateName;
        this.solutionStackName = builder.solutionStackName;
        this.platformArn = builder.platformArn;
        this.optionSettings = builder.optionSettings;
        this.optionsToRemove = builder.optionsToRemove;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public String groupName() {
        return this.groupName;
    }

    public String description() {
        return this.description;
    }

    public EnvironmentTier tier() {
        return this.tier;
    }

    public String versionLabel() {
        return this.versionLabel;
    }

    public String templateName() {
        return this.templateName;
    }

    public String solutionStackName() {
        return this.solutionStackName;
    }

    public String platformArn() {
        return this.platformArn;
    }

    public List<ConfigurationOptionSetting> optionSettings() {
        return this.optionSettings;
    }

    public List<OptionSpecification> optionsToRemove() {
        return this.optionsToRemove;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.environmentId() == null ? 0 : this.environmentId().hashCode());
        hashCode = 31 * hashCode + (this.environmentName() == null ? 0 : this.environmentName().hashCode());
        hashCode = 31 * hashCode + (this.groupName() == null ? 0 : this.groupName().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.tier() == null ? 0 : this.tier().hashCode());
        hashCode = 31 * hashCode + (this.versionLabel() == null ? 0 : this.versionLabel().hashCode());
        hashCode = 31 * hashCode + (this.templateName() == null ? 0 : this.templateName().hashCode());
        hashCode = 31 * hashCode + (this.solutionStackName() == null ? 0 : this.solutionStackName().hashCode());
        hashCode = 31 * hashCode + (this.platformArn() == null ? 0 : this.platformArn().hashCode());
        hashCode = 31 * hashCode + (this.optionSettings() == null ? 0 : this.optionSettings().hashCode());
        hashCode = 31 * hashCode + (this.optionsToRemove() == null ? 0 : this.optionsToRemove().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEnvironmentRequest)) {
            return false;
        }
        UpdateEnvironmentRequest other = (UpdateEnvironmentRequest)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.environmentId() == null ^ this.environmentId() == null) {
            return false;
        }
        if (other.environmentId() != null && !other.environmentId().equals(this.environmentId())) {
            return false;
        }
        if (other.environmentName() == null ^ this.environmentName() == null) {
            return false;
        }
        if (other.environmentName() != null && !other.environmentName().equals(this.environmentName())) {
            return false;
        }
        if (other.groupName() == null ^ this.groupName() == null) {
            return false;
        }
        if (other.groupName() != null && !other.groupName().equals(this.groupName())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.tier() == null ^ this.tier() == null) {
            return false;
        }
        if (other.tier() != null && !other.tier().equals(this.tier())) {
            return false;
        }
        if (other.versionLabel() == null ^ this.versionLabel() == null) {
            return false;
        }
        if (other.versionLabel() != null && !other.versionLabel().equals(this.versionLabel())) {
            return false;
        }
        if (other.templateName() == null ^ this.templateName() == null) {
            return false;
        }
        if (other.templateName() != null && !other.templateName().equals(this.templateName())) {
            return false;
        }
        if (other.solutionStackName() == null ^ this.solutionStackName() == null) {
            return false;
        }
        if (other.solutionStackName() != null && !other.solutionStackName().equals(this.solutionStackName())) {
            return false;
        }
        if (other.platformArn() == null ^ this.platformArn() == null) {
            return false;
        }
        if (other.platformArn() != null && !other.platformArn().equals(this.platformArn())) {
            return false;
        }
        if (other.optionSettings() == null ^ this.optionSettings() == null) {
            return false;
        }
        if (other.optionSettings() != null && !other.optionSettings().equals(this.optionSettings())) {
            return false;
        }
        if (other.optionsToRemove() == null ^ this.optionsToRemove() == null) {
            return false;
        }
        return other.optionsToRemove() == null || other.optionsToRemove().equals(this.optionsToRemove());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.environmentId() != null) {
            sb.append("EnvironmentId: ").append(this.environmentId()).append(",");
        }
        if (this.environmentName() != null) {
            sb.append("EnvironmentName: ").append(this.environmentName()).append(",");
        }
        if (this.groupName() != null) {
            sb.append("GroupName: ").append(this.groupName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.tier() != null) {
            sb.append("Tier: ").append(this.tier()).append(",");
        }
        if (this.versionLabel() != null) {
            sb.append("VersionLabel: ").append(this.versionLabel()).append(",");
        }
        if (this.templateName() != null) {
            sb.append("TemplateName: ").append(this.templateName()).append(",");
        }
        if (this.solutionStackName() != null) {
            sb.append("SolutionStackName: ").append(this.solutionStackName()).append(",");
        }
        if (this.platformArn() != null) {
            sb.append("PlatformArn: ").append(this.platformArn()).append(",");
        }
        if (this.optionSettings() != null) {
            sb.append("OptionSettings: ").append(this.optionSettings()).append(",");
        }
        if (this.optionsToRemove() != null) {
            sb.append("OptionsToRemove: ").append(this.optionsToRemove()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String environmentId;
        private String environmentName;
        private String groupName;
        private String description;
        private EnvironmentTier tier;
        private String versionLabel;
        private String templateName;
        private String solutionStackName;
        private String platformArn;
        private List<ConfigurationOptionSetting> optionSettings = new SdkInternalList();
        private List<OptionSpecification> optionsToRemove = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEnvironmentRequest model) {
            this.setApplicationName(model.applicationName);
            this.setEnvironmentId(model.environmentId);
            this.setEnvironmentName(model.environmentName);
            this.setGroupName(model.groupName);
            this.setDescription(model.description);
            this.setTier(model.tier);
            this.setVersionLabel(model.versionLabel);
            this.setTemplateName(model.templateName);
            this.setSolutionStackName(model.solutionStackName);
            this.setPlatformArn(model.platformArn);
            this.setOptionSettings(model.optionSettings);
            this.setOptionsToRemove(model.optionsToRemove);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final EnvironmentTier getTier() {
            return this.tier;
        }

        @Override
        public final Builder tier(EnvironmentTier tier) {
            this.tier = tier;
            return this;
        }

        public final void setTier(EnvironmentTier tier) {
            this.tier = tier;
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getSolutionStackName() {
            return this.solutionStackName;
        }

        @Override
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        public final String getPlatformArn() {
            return this.platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final Collection<ConfigurationOptionSetting> getOptionSettings() {
            return this.optionSettings;
        }

        @Override
        public final Builder optionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copy(optionSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(ConfigurationOptionSetting ... optionSettings) {
            if (this.optionSettings == null) {
                this.optionSettings = new SdkInternalList(optionSettings.length);
            }
            for (ConfigurationOptionSetting e : optionSettings) {
                this.optionSettings.add(e);
            }
            return this;
        }

        public final void setOptionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copy(optionSettings);
        }

        @SafeVarargs
        public final void setOptionSettings(ConfigurationOptionSetting ... optionSettings) {
            if (this.optionSettings == null) {
                this.optionSettings = new SdkInternalList(optionSettings.length);
            }
            for (ConfigurationOptionSetting e : optionSettings) {
                this.optionSettings.add(e);
            }
        }

        public final Collection<OptionSpecification> getOptionsToRemove() {
            return this.optionsToRemove;
        }

        @Override
        public final Builder optionsToRemove(Collection<OptionSpecification> optionsToRemove) {
            this.optionsToRemove = OptionsSpecifierListCopier.copy(optionsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsToRemove(OptionSpecification ... optionsToRemove) {
            if (this.optionsToRemove == null) {
                this.optionsToRemove = new SdkInternalList(optionsToRemove.length);
            }
            for (OptionSpecification e : optionsToRemove) {
                this.optionsToRemove.add(e);
            }
            return this;
        }

        public final void setOptionsToRemove(Collection<OptionSpecification> optionsToRemove) {
            this.optionsToRemove = OptionsSpecifierListCopier.copy(optionsToRemove);
        }

        @SafeVarargs
        public final void setOptionsToRemove(OptionSpecification ... optionsToRemove) {
            if (this.optionsToRemove == null) {
                this.optionsToRemove = new SdkInternalList(optionsToRemove.length);
            }
            for (OptionSpecification e : optionsToRemove) {
                this.optionsToRemove.add(e);
            }
        }

        public UpdateEnvironmentRequest build() {
            return new UpdateEnvironmentRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateEnvironmentRequest> {
        public Builder applicationName(String var1);

        public Builder environmentId(String var1);

        public Builder environmentName(String var1);

        public Builder groupName(String var1);

        public Builder description(String var1);

        public Builder tier(EnvironmentTier var1);

        public Builder versionLabel(String var1);

        public Builder templateName(String var1);

        public Builder solutionStackName(String var1);

        public Builder platformArn(String var1);

        public Builder optionSettings(Collection<ConfigurationOptionSetting> var1);

        public Builder optionSettings(ConfigurationOptionSetting ... var1);

        public Builder optionsToRemove(Collection<OptionSpecification> var1);

        public Builder optionsToRemove(OptionSpecification ... var1);
    }
}

