/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformStatus;
import software.amazon.awssdk.services.elasticbeanstalk.model.SupportedAddonListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.SupportedTierListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PlatformSummary
implements ToCopyableBuilder<Builder, PlatformSummary> {
    private final String platformArn;
    private final String platformOwner;
    private final String platformStatus;
    private final String platformCategory;
    private final String operatingSystemName;
    private final String operatingSystemVersion;
    private final List<String> supportedTierList;
    private final List<String> supportedAddonList;

    private PlatformSummary(BuilderImpl builder) {
        this.platformArn = builder.platformArn;
        this.platformOwner = builder.platformOwner;
        this.platformStatus = builder.platformStatus;
        this.platformCategory = builder.platformCategory;
        this.operatingSystemName = builder.operatingSystemName;
        this.operatingSystemVersion = builder.operatingSystemVersion;
        this.supportedTierList = builder.supportedTierList;
        this.supportedAddonList = builder.supportedAddonList;
    }

    public String platformArn() {
        return this.platformArn;
    }

    public String platformOwner() {
        return this.platformOwner;
    }

    public String platformStatus() {
        return this.platformStatus;
    }

    public String platformCategory() {
        return this.platformCategory;
    }

    public String operatingSystemName() {
        return this.operatingSystemName;
    }

    public String operatingSystemVersion() {
        return this.operatingSystemVersion;
    }

    public List<String> supportedTierList() {
        return this.supportedTierList;
    }

    public List<String> supportedAddonList() {
        return this.supportedAddonList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.platformArn() == null ? 0 : this.platformArn().hashCode());
        hashCode = 31 * hashCode + (this.platformOwner() == null ? 0 : this.platformOwner().hashCode());
        hashCode = 31 * hashCode + (this.platformStatus() == null ? 0 : this.platformStatus().hashCode());
        hashCode = 31 * hashCode + (this.platformCategory() == null ? 0 : this.platformCategory().hashCode());
        hashCode = 31 * hashCode + (this.operatingSystemName() == null ? 0 : this.operatingSystemName().hashCode());
        hashCode = 31 * hashCode + (this.operatingSystemVersion() == null ? 0 : this.operatingSystemVersion().hashCode());
        hashCode = 31 * hashCode + (this.supportedTierList() == null ? 0 : this.supportedTierList().hashCode());
        hashCode = 31 * hashCode + (this.supportedAddonList() == null ? 0 : this.supportedAddonList().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlatformSummary)) {
            return false;
        }
        PlatformSummary other = (PlatformSummary)obj;
        if (other.platformArn() == null ^ this.platformArn() == null) {
            return false;
        }
        if (other.platformArn() != null && !other.platformArn().equals(this.platformArn())) {
            return false;
        }
        if (other.platformOwner() == null ^ this.platformOwner() == null) {
            return false;
        }
        if (other.platformOwner() != null && !other.platformOwner().equals(this.platformOwner())) {
            return false;
        }
        if (other.platformStatus() == null ^ this.platformStatus() == null) {
            return false;
        }
        if (other.platformStatus() != null && !other.platformStatus().equals(this.platformStatus())) {
            return false;
        }
        if (other.platformCategory() == null ^ this.platformCategory() == null) {
            return false;
        }
        if (other.platformCategory() != null && !other.platformCategory().equals(this.platformCategory())) {
            return false;
        }
        if (other.operatingSystemName() == null ^ this.operatingSystemName() == null) {
            return false;
        }
        if (other.operatingSystemName() != null && !other.operatingSystemName().equals(this.operatingSystemName())) {
            return false;
        }
        if (other.operatingSystemVersion() == null ^ this.operatingSystemVersion() == null) {
            return false;
        }
        if (other.operatingSystemVersion() != null && !other.operatingSystemVersion().equals(this.operatingSystemVersion())) {
            return false;
        }
        if (other.supportedTierList() == null ^ this.supportedTierList() == null) {
            return false;
        }
        if (other.supportedTierList() != null && !other.supportedTierList().equals(this.supportedTierList())) {
            return false;
        }
        if (other.supportedAddonList() == null ^ this.supportedAddonList() == null) {
            return false;
        }
        return other.supportedAddonList() == null || other.supportedAddonList().equals(this.supportedAddonList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.platformArn() != null) {
            sb.append("PlatformArn: ").append(this.platformArn()).append(",");
        }
        if (this.platformOwner() != null) {
            sb.append("PlatformOwner: ").append(this.platformOwner()).append(",");
        }
        if (this.platformStatus() != null) {
            sb.append("PlatformStatus: ").append(this.platformStatus()).append(",");
        }
        if (this.platformCategory() != null) {
            sb.append("PlatformCategory: ").append(this.platformCategory()).append(",");
        }
        if (this.operatingSystemName() != null) {
            sb.append("OperatingSystemName: ").append(this.operatingSystemName()).append(",");
        }
        if (this.operatingSystemVersion() != null) {
            sb.append("OperatingSystemVersion: ").append(this.operatingSystemVersion()).append(",");
        }
        if (this.supportedTierList() != null) {
            sb.append("SupportedTierList: ").append(this.supportedTierList()).append(",");
        }
        if (this.supportedAddonList() != null) {
            sb.append("SupportedAddonList: ").append(this.supportedAddonList()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String platformArn;
        private String platformOwner;
        private String platformStatus;
        private String platformCategory;
        private String operatingSystemName;
        private String operatingSystemVersion;
        private List<String> supportedTierList = new SdkInternalList();
        private List<String> supportedAddonList = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(PlatformSummary model) {
            this.setPlatformArn(model.platformArn);
            this.setPlatformOwner(model.platformOwner);
            this.setPlatformStatus(model.platformStatus);
            this.setPlatformCategory(model.platformCategory);
            this.setOperatingSystemName(model.operatingSystemName);
            this.setOperatingSystemVersion(model.operatingSystemVersion);
            this.setSupportedTierList(model.supportedTierList);
            this.setSupportedAddonList(model.supportedAddonList);
        }

        public final String getPlatformArn() {
            return this.platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final String getPlatformOwner() {
            return this.platformOwner;
        }

        @Override
        public final Builder platformOwner(String platformOwner) {
            this.platformOwner = platformOwner;
            return this;
        }

        public final void setPlatformOwner(String platformOwner) {
            this.platformOwner = platformOwner;
        }

        public final String getPlatformStatus() {
            return this.platformStatus;
        }

        @Override
        public final Builder platformStatus(String platformStatus) {
            this.platformStatus = platformStatus;
            return this;
        }

        @Override
        public final Builder platformStatus(PlatformStatus platformStatus) {
            this.platformStatus(platformStatus.toString());
            return this;
        }

        public final void setPlatformStatus(String platformStatus) {
            this.platformStatus = platformStatus;
        }

        public final void setPlatformStatus(PlatformStatus platformStatus) {
            this.platformStatus(platformStatus.toString());
        }

        public final String getPlatformCategory() {
            return this.platformCategory;
        }

        @Override
        public final Builder platformCategory(String platformCategory) {
            this.platformCategory = platformCategory;
            return this;
        }

        public final void setPlatformCategory(String platformCategory) {
            this.platformCategory = platformCategory;
        }

        public final String getOperatingSystemName() {
            return this.operatingSystemName;
        }

        @Override
        public final Builder operatingSystemName(String operatingSystemName) {
            this.operatingSystemName = operatingSystemName;
            return this;
        }

        public final void setOperatingSystemName(String operatingSystemName) {
            this.operatingSystemName = operatingSystemName;
        }

        public final String getOperatingSystemVersion() {
            return this.operatingSystemVersion;
        }

        @Override
        public final Builder operatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
            return this;
        }

        public final void setOperatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
        }

        public final Collection<String> getSupportedTierList() {
            return this.supportedTierList;
        }

        @Override
        public final Builder supportedTierList(Collection<String> supportedTierList) {
            this.supportedTierList = SupportedTierListCopier.copy(supportedTierList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTierList(String ... supportedTierList) {
            if (this.supportedTierList == null) {
                this.supportedTierList = new SdkInternalList(supportedTierList.length);
            }
            for (String e : supportedTierList) {
                this.supportedTierList.add(e);
            }
            return this;
        }

        public final void setSupportedTierList(Collection<String> supportedTierList) {
            this.supportedTierList = SupportedTierListCopier.copy(supportedTierList);
        }

        @SafeVarargs
        public final void setSupportedTierList(String ... supportedTierList) {
            if (this.supportedTierList == null) {
                this.supportedTierList = new SdkInternalList(supportedTierList.length);
            }
            for (String e : supportedTierList) {
                this.supportedTierList.add(e);
            }
        }

        public final Collection<String> getSupportedAddonList() {
            return this.supportedAddonList;
        }

        @Override
        public final Builder supportedAddonList(Collection<String> supportedAddonList) {
            this.supportedAddonList = SupportedAddonListCopier.copy(supportedAddonList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedAddonList(String ... supportedAddonList) {
            if (this.supportedAddonList == null) {
                this.supportedAddonList = new SdkInternalList(supportedAddonList.length);
            }
            for (String e : supportedAddonList) {
                this.supportedAddonList.add(e);
            }
            return this;
        }

        public final void setSupportedAddonList(Collection<String> supportedAddonList) {
            this.supportedAddonList = SupportedAddonListCopier.copy(supportedAddonList);
        }

        @SafeVarargs
        public final void setSupportedAddonList(String ... supportedAddonList) {
            if (this.supportedAddonList == null) {
                this.supportedAddonList = new SdkInternalList(supportedAddonList.length);
            }
            for (String e : supportedAddonList) {
                this.supportedAddonList.add(e);
            }
        }

        public PlatformSummary build() {
            return new PlatformSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PlatformSummary> {
        public Builder platformArn(String var1);

        public Builder platformOwner(String var1);

        public Builder platformStatus(String var1);

        public Builder platformStatus(PlatformStatus var1);

        public Builder platformCategory(String var1);

        public Builder operatingSystemName(String var1);

        public Builder operatingSystemVersion(String var1);

        public Builder supportedTierList(Collection<String> var1);

        public Builder supportedTierList(String ... var1);

        public Builder supportedAddonList(Collection<String> var1);

        public Builder supportedAddonList(String ... var1);
    }
}

