/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.elasticbeanstalk.model.AutoScalingGroup;
import software.amazon.awssdk.services.elasticbeanstalk.model.AutoScalingGroupListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.Instance;
import software.amazon.awssdk.services.elasticbeanstalk.model.InstanceListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.LaunchConfiguration;
import software.amazon.awssdk.services.elasticbeanstalk.model.LaunchConfigurationListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.LoadBalancer;
import software.amazon.awssdk.services.elasticbeanstalk.model.LoadBalancerListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.Queue;
import software.amazon.awssdk.services.elasticbeanstalk.model.QueueListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.Trigger;
import software.amazon.awssdk.services.elasticbeanstalk.model.TriggerListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnvironmentResourceDescription
implements ToCopyableBuilder<Builder, EnvironmentResourceDescription> {
    private final String environmentName;
    private final List<AutoScalingGroup> autoScalingGroups;
    private final List<Instance> instances;
    private final List<LaunchConfiguration> launchConfigurations;
    private final List<LoadBalancer> loadBalancers;
    private final List<Trigger> triggers;
    private final List<Queue> queues;

    private EnvironmentResourceDescription(BuilderImpl builder) {
        this.environmentName = builder.environmentName;
        this.autoScalingGroups = builder.autoScalingGroups;
        this.instances = builder.instances;
        this.launchConfigurations = builder.launchConfigurations;
        this.loadBalancers = builder.loadBalancers;
        this.triggers = builder.triggers;
        this.queues = builder.queues;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public List<AutoScalingGroup> autoScalingGroups() {
        return this.autoScalingGroups;
    }

    public List<Instance> instances() {
        return this.instances;
    }

    public List<LaunchConfiguration> launchConfigurations() {
        return this.launchConfigurations;
    }

    public List<LoadBalancer> loadBalancers() {
        return this.loadBalancers;
    }

    public List<Trigger> triggers() {
        return this.triggers;
    }

    public List<Queue> queues() {
        return this.queues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.environmentName() == null ? 0 : this.environmentName().hashCode());
        hashCode = 31 * hashCode + (this.autoScalingGroups() == null ? 0 : this.autoScalingGroups().hashCode());
        hashCode = 31 * hashCode + (this.instances() == null ? 0 : this.instances().hashCode());
        hashCode = 31 * hashCode + (this.launchConfigurations() == null ? 0 : this.launchConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.loadBalancers() == null ? 0 : this.loadBalancers().hashCode());
        hashCode = 31 * hashCode + (this.triggers() == null ? 0 : this.triggers().hashCode());
        hashCode = 31 * hashCode + (this.queues() == null ? 0 : this.queues().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentResourceDescription)) {
            return false;
        }
        EnvironmentResourceDescription other = (EnvironmentResourceDescription)obj;
        if (other.environmentName() == null ^ this.environmentName() == null) {
            return false;
        }
        if (other.environmentName() != null && !other.environmentName().equals(this.environmentName())) {
            return false;
        }
        if (other.autoScalingGroups() == null ^ this.autoScalingGroups() == null) {
            return false;
        }
        if (other.autoScalingGroups() != null && !other.autoScalingGroups().equals(this.autoScalingGroups())) {
            return false;
        }
        if (other.instances() == null ^ this.instances() == null) {
            return false;
        }
        if (other.instances() != null && !other.instances().equals(this.instances())) {
            return false;
        }
        if (other.launchConfigurations() == null ^ this.launchConfigurations() == null) {
            return false;
        }
        if (other.launchConfigurations() != null && !other.launchConfigurations().equals(this.launchConfigurations())) {
            return false;
        }
        if (other.loadBalancers() == null ^ this.loadBalancers() == null) {
            return false;
        }
        if (other.loadBalancers() != null && !other.loadBalancers().equals(this.loadBalancers())) {
            return false;
        }
        if (other.triggers() == null ^ this.triggers() == null) {
            return false;
        }
        if (other.triggers() != null && !other.triggers().equals(this.triggers())) {
            return false;
        }
        if (other.queues() == null ^ this.queues() == null) {
            return false;
        }
        return other.queues() == null || other.queues().equals(this.queues());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.environmentName() != null) {
            sb.append("EnvironmentName: ").append(this.environmentName()).append(",");
        }
        if (this.autoScalingGroups() != null) {
            sb.append("AutoScalingGroups: ").append(this.autoScalingGroups()).append(",");
        }
        if (this.instances() != null) {
            sb.append("Instances: ").append(this.instances()).append(",");
        }
        if (this.launchConfigurations() != null) {
            sb.append("LaunchConfigurations: ").append(this.launchConfigurations()).append(",");
        }
        if (this.loadBalancers() != null) {
            sb.append("LoadBalancers: ").append(this.loadBalancers()).append(",");
        }
        if (this.triggers() != null) {
            sb.append("Triggers: ").append(this.triggers()).append(",");
        }
        if (this.queues() != null) {
            sb.append("Queues: ").append(this.queues()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String environmentName;
        private List<AutoScalingGroup> autoScalingGroups = new SdkInternalList();
        private List<Instance> instances = new SdkInternalList();
        private List<LaunchConfiguration> launchConfigurations = new SdkInternalList();
        private List<LoadBalancer> loadBalancers = new SdkInternalList();
        private List<Trigger> triggers = new SdkInternalList();
        private List<Queue> queues = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentResourceDescription model) {
            this.setEnvironmentName(model.environmentName);
            this.setAutoScalingGroups(model.autoScalingGroups);
            this.setInstances(model.instances);
            this.setLaunchConfigurations(model.launchConfigurations);
            this.setLoadBalancers(model.loadBalancers);
            this.setTriggers(model.triggers);
            this.setQueues(model.queues);
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final Collection<AutoScalingGroup> getAutoScalingGroups() {
            return this.autoScalingGroups;
        }

        @Override
        public final Builder autoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupListCopier.copy(autoScalingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(AutoScalingGroup ... autoScalingGroups) {
            if (this.autoScalingGroups == null) {
                this.autoScalingGroups = new SdkInternalList(autoScalingGroups.length);
            }
            for (AutoScalingGroup e : autoScalingGroups) {
                this.autoScalingGroups.add(e);
            }
            return this;
        }

        public final void setAutoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupListCopier.copy(autoScalingGroups);
        }

        @SafeVarargs
        public final void setAutoScalingGroups(AutoScalingGroup ... autoScalingGroups) {
            if (this.autoScalingGroups == null) {
                this.autoScalingGroups = new SdkInternalList(autoScalingGroups.length);
            }
            for (AutoScalingGroup e : autoScalingGroups) {
                this.autoScalingGroups.add(e);
            }
        }

        public final Collection<Instance> getInstances() {
            return this.instances;
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstanceListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance ... instances) {
            if (this.instances == null) {
                this.instances = new SdkInternalList(instances.length);
            }
            for (Instance e : instances) {
                this.instances.add(e);
            }
            return this;
        }

        public final void setInstances(Collection<Instance> instances) {
            this.instances = InstanceListCopier.copy(instances);
        }

        @SafeVarargs
        public final void setInstances(Instance ... instances) {
            if (this.instances == null) {
                this.instances = new SdkInternalList(instances.length);
            }
            for (Instance e : instances) {
                this.instances.add(e);
            }
        }

        public final Collection<LaunchConfiguration> getLaunchConfigurations() {
            return this.launchConfigurations;
        }

        @Override
        public final Builder launchConfigurations(Collection<LaunchConfiguration> launchConfigurations) {
            this.launchConfigurations = LaunchConfigurationListCopier.copy(launchConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchConfigurations(LaunchConfiguration ... launchConfigurations) {
            if (this.launchConfigurations == null) {
                this.launchConfigurations = new SdkInternalList(launchConfigurations.length);
            }
            for (LaunchConfiguration e : launchConfigurations) {
                this.launchConfigurations.add(e);
            }
            return this;
        }

        public final void setLaunchConfigurations(Collection<LaunchConfiguration> launchConfigurations) {
            this.launchConfigurations = LaunchConfigurationListCopier.copy(launchConfigurations);
        }

        @SafeVarargs
        public final void setLaunchConfigurations(LaunchConfiguration ... launchConfigurations) {
            if (this.launchConfigurations == null) {
                this.launchConfigurations = new SdkInternalList(launchConfigurations.length);
            }
            for (LaunchConfiguration e : launchConfigurations) {
                this.launchConfigurations.add(e);
            }
        }

        public final Collection<LoadBalancer> getLoadBalancers() {
            return this.loadBalancers;
        }

        @Override
        public final Builder loadBalancers(Collection<LoadBalancer> loadBalancers) {
            this.loadBalancers = LoadBalancerListCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(LoadBalancer ... loadBalancers) {
            if (this.loadBalancers == null) {
                this.loadBalancers = new SdkInternalList(loadBalancers.length);
            }
            for (LoadBalancer e : loadBalancers) {
                this.loadBalancers.add(e);
            }
            return this;
        }

        public final void setLoadBalancers(Collection<LoadBalancer> loadBalancers) {
            this.loadBalancers = LoadBalancerListCopier.copy(loadBalancers);
        }

        @SafeVarargs
        public final void setLoadBalancers(LoadBalancer ... loadBalancers) {
            if (this.loadBalancers == null) {
                this.loadBalancers = new SdkInternalList(loadBalancers.length);
            }
            for (LoadBalancer e : loadBalancers) {
                this.loadBalancers.add(e);
            }
        }

        public final Collection<Trigger> getTriggers() {
            return this.triggers;
        }

        @Override
        public final Builder triggers(Collection<Trigger> triggers) {
            this.triggers = TriggerListCopier.copy(triggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Trigger ... triggers) {
            if (this.triggers == null) {
                this.triggers = new SdkInternalList(triggers.length);
            }
            for (Trigger e : triggers) {
                this.triggers.add(e);
            }
            return this;
        }

        public final void setTriggers(Collection<Trigger> triggers) {
            this.triggers = TriggerListCopier.copy(triggers);
        }

        @SafeVarargs
        public final void setTriggers(Trigger ... triggers) {
            if (this.triggers == null) {
                this.triggers = new SdkInternalList(triggers.length);
            }
            for (Trigger e : triggers) {
                this.triggers.add(e);
            }
        }

        public final Collection<Queue> getQueues() {
            return this.queues;
        }

        @Override
        public final Builder queues(Collection<Queue> queues) {
            this.queues = QueueListCopier.copy(queues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queues(Queue ... queues) {
            if (this.queues == null) {
                this.queues = new SdkInternalList(queues.length);
            }
            for (Queue e : queues) {
                this.queues.add(e);
            }
            return this;
        }

        public final void setQueues(Collection<Queue> queues) {
            this.queues = QueueListCopier.copy(queues);
        }

        @SafeVarargs
        public final void setQueues(Queue ... queues) {
            if (this.queues == null) {
                this.queues = new SdkInternalList(queues.length);
            }
            for (Queue e : queues) {
                this.queues.add(e);
            }
        }

        public EnvironmentResourceDescription build() {
            return new EnvironmentResourceDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnvironmentResourceDescription> {
        public Builder environmentName(String var1);

        public Builder autoScalingGroups(Collection<AutoScalingGroup> var1);

        public Builder autoScalingGroups(AutoScalingGroup ... var1);

        public Builder instances(Collection<Instance> var1);

        public Builder instances(Instance ... var1);

        public Builder launchConfigurations(Collection<LaunchConfiguration> var1);

        public Builder launchConfigurations(LaunchConfiguration ... var1);

        public Builder loadBalancers(Collection<LoadBalancer> var1);

        public Builder loadBalancers(LoadBalancer ... var1);

        public Builder triggers(Collection<Trigger> var1);

        public Builder triggers(Trigger ... var1);

        public Builder queues(Collection<Queue> var1);

        public Builder queues(Queue ... var1);
    }
}

