/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ApplyEnvironmentManagedActionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ApplyEnvironmentManagedActionRequest> {
    private final String environmentName;
    private final String environmentId;
    private final String actionId;

    private ApplyEnvironmentManagedActionRequest(BuilderImpl builder) {
        this.environmentName = builder.environmentName;
        this.environmentId = builder.environmentId;
        this.actionId = builder.actionId;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String actionId() {
        return this.actionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.environmentName() == null ? 0 : this.environmentName().hashCode());
        hashCode = 31 * hashCode + (this.environmentId() == null ? 0 : this.environmentId().hashCode());
        hashCode = 31 * hashCode + (this.actionId() == null ? 0 : this.actionId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplyEnvironmentManagedActionRequest)) {
            return false;
        }
        ApplyEnvironmentManagedActionRequest other = (ApplyEnvironmentManagedActionRequest)((Object)obj);
        if (other.environmentName() == null ^ this.environmentName() == null) {
            return false;
        }
        if (other.environmentName() != null && !other.environmentName().equals(this.environmentName())) {
            return false;
        }
        if (other.environmentId() == null ^ this.environmentId() == null) {
            return false;
        }
        if (other.environmentId() != null && !other.environmentId().equals(this.environmentId())) {
            return false;
        }
        if (other.actionId() == null ^ this.actionId() == null) {
            return false;
        }
        return other.actionId() == null || other.actionId().equals(this.actionId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.environmentName() != null) {
            sb.append("EnvironmentName: ").append(this.environmentName()).append(",");
        }
        if (this.environmentId() != null) {
            sb.append("EnvironmentId: ").append(this.environmentId()).append(",");
        }
        if (this.actionId() != null) {
            sb.append("ActionId: ").append(this.actionId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String environmentName;
        private String environmentId;
        private String actionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplyEnvironmentManagedActionRequest model) {
            this.setEnvironmentName(model.environmentName);
            this.setEnvironmentId(model.environmentId);
            this.setActionId(model.actionId);
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final String getActionId() {
            return this.actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        public ApplyEnvironmentManagedActionRequest build() {
            return new ApplyEnvironmentManagedActionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ApplyEnvironmentManagedActionRequest> {
        public Builder environmentName(String var1);

        public Builder environmentId(String var1);

        public Builder actionId(String var1);
    }
}

