/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Date;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionStatus;
import software.amazon.awssdk.services.elasticbeanstalk.model.S3Location;
import software.amazon.awssdk.services.elasticbeanstalk.model.SourceBuildInformation;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ApplicationVersionDescription
implements ToCopyableBuilder<Builder, ApplicationVersionDescription> {
    private final String applicationName;
    private final String description;
    private final String versionLabel;
    private final SourceBuildInformation sourceBuildInformation;
    private final String buildArn;
    private final S3Location sourceBundle;
    private final Date dateCreated;
    private final Date dateUpdated;
    private final String status;

    private ApplicationVersionDescription(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.description = builder.description;
        this.versionLabel = builder.versionLabel;
        this.sourceBuildInformation = builder.sourceBuildInformation;
        this.buildArn = builder.buildArn;
        this.sourceBundle = builder.sourceBundle;
        this.dateCreated = builder.dateCreated;
        this.dateUpdated = builder.dateUpdated;
        this.status = builder.status;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String description() {
        return this.description;
    }

    public String versionLabel() {
        return this.versionLabel;
    }

    public SourceBuildInformation sourceBuildInformation() {
        return this.sourceBuildInformation;
    }

    public String buildArn() {
        return this.buildArn;
    }

    public S3Location sourceBundle() {
        return this.sourceBundle;
    }

    public Date dateCreated() {
        return this.dateCreated;
    }

    public Date dateUpdated() {
        return this.dateUpdated;
    }

    public String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.versionLabel() == null ? 0 : this.versionLabel().hashCode());
        hashCode = 31 * hashCode + (this.sourceBuildInformation() == null ? 0 : this.sourceBuildInformation().hashCode());
        hashCode = 31 * hashCode + (this.buildArn() == null ? 0 : this.buildArn().hashCode());
        hashCode = 31 * hashCode + (this.sourceBundle() == null ? 0 : this.sourceBundle().hashCode());
        hashCode = 31 * hashCode + (this.dateCreated() == null ? 0 : this.dateCreated().hashCode());
        hashCode = 31 * hashCode + (this.dateUpdated() == null ? 0 : this.dateUpdated().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationVersionDescription)) {
            return false;
        }
        ApplicationVersionDescription other = (ApplicationVersionDescription)obj;
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.versionLabel() == null ^ this.versionLabel() == null) {
            return false;
        }
        if (other.versionLabel() != null && !other.versionLabel().equals(this.versionLabel())) {
            return false;
        }
        if (other.sourceBuildInformation() == null ^ this.sourceBuildInformation() == null) {
            return false;
        }
        if (other.sourceBuildInformation() != null && !other.sourceBuildInformation().equals(this.sourceBuildInformation())) {
            return false;
        }
        if (other.buildArn() == null ^ this.buildArn() == null) {
            return false;
        }
        if (other.buildArn() != null && !other.buildArn().equals(this.buildArn())) {
            return false;
        }
        if (other.sourceBundle() == null ^ this.sourceBundle() == null) {
            return false;
        }
        if (other.sourceBundle() != null && !other.sourceBundle().equals(this.sourceBundle())) {
            return false;
        }
        if (other.dateCreated() == null ^ this.dateCreated() == null) {
            return false;
        }
        if (other.dateCreated() != null && !other.dateCreated().equals(this.dateCreated())) {
            return false;
        }
        if (other.dateUpdated() == null ^ this.dateUpdated() == null) {
            return false;
        }
        if (other.dateUpdated() != null && !other.dateUpdated().equals(this.dateUpdated())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        return other.status() == null || other.status().equals(this.status());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.versionLabel() != null) {
            sb.append("VersionLabel: ").append(this.versionLabel()).append(",");
        }
        if (this.sourceBuildInformation() != null) {
            sb.append("SourceBuildInformation: ").append(this.sourceBuildInformation()).append(",");
        }
        if (this.buildArn() != null) {
            sb.append("BuildArn: ").append(this.buildArn()).append(",");
        }
        if (this.sourceBundle() != null) {
            sb.append("SourceBundle: ").append(this.sourceBundle()).append(",");
        }
        if (this.dateCreated() != null) {
            sb.append("DateCreated: ").append(this.dateCreated()).append(",");
        }
        if (this.dateUpdated() != null) {
            sb.append("DateUpdated: ").append(this.dateUpdated()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String description;
        private String versionLabel;
        private SourceBuildInformation sourceBuildInformation;
        private String buildArn;
        private S3Location sourceBundle;
        private Date dateCreated;
        private Date dateUpdated;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationVersionDescription model) {
            this.setApplicationName(model.applicationName);
            this.setDescription(model.description);
            this.setVersionLabel(model.versionLabel);
            this.setSourceBuildInformation(model.sourceBuildInformation);
            this.setBuildArn(model.buildArn);
            this.setSourceBundle(model.sourceBundle);
            this.setDateCreated(model.dateCreated);
            this.setDateUpdated(model.dateUpdated);
            this.setStatus(model.status);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        public final SourceBuildInformation getSourceBuildInformation() {
            return this.sourceBuildInformation;
        }

        @Override
        public final Builder sourceBuildInformation(SourceBuildInformation sourceBuildInformation) {
            this.sourceBuildInformation = sourceBuildInformation;
            return this;
        }

        public final void setSourceBuildInformation(SourceBuildInformation sourceBuildInformation) {
            this.sourceBuildInformation = sourceBuildInformation;
        }

        public final String getBuildArn() {
            return this.buildArn;
        }

        @Override
        public final Builder buildArn(String buildArn) {
            this.buildArn = buildArn;
            return this;
        }

        public final void setBuildArn(String buildArn) {
            this.buildArn = buildArn;
        }

        public final S3Location getSourceBundle() {
            return this.sourceBundle;
        }

        @Override
        public final Builder sourceBundle(S3Location sourceBundle) {
            this.sourceBundle = sourceBundle;
            return this;
        }

        public final void setSourceBundle(S3Location sourceBundle) {
            this.sourceBundle = sourceBundle;
        }

        public final Date getDateCreated() {
            return this.dateCreated;
        }

        @Override
        public final Builder dateCreated(Date dateCreated) {
            this.dateCreated = StandardMemberCopier.copy((Date)dateCreated);
            return this;
        }

        public final void setDateCreated(Date dateCreated) {
            this.dateCreated = StandardMemberCopier.copy((Date)dateCreated);
        }

        public final Date getDateUpdated() {
            return this.dateUpdated;
        }

        @Override
        public final Builder dateUpdated(Date dateUpdated) {
            this.dateUpdated = StandardMemberCopier.copy((Date)dateUpdated);
            return this;
        }

        public final void setDateUpdated(Date dateUpdated) {
            this.dateUpdated = StandardMemberCopier.copy((Date)dateUpdated);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationVersionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(ApplicationVersionStatus status) {
            this.status(status.toString());
        }

        public ApplicationVersionDescription build() {
            return new ApplicationVersionDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ApplicationVersionDescription> {
        public Builder applicationName(String var1);

        public Builder description(String var1);

        public Builder versionLabel(String var1);

        public Builder sourceBuildInformation(SourceBuildInformation var1);

        public Builder buildArn(String var1);

        public Builder sourceBundle(S3Location var1);

        public Builder dateCreated(Date var1);

        public Builder dateUpdated(Date var1);

        public Builder status(String var1);

        public Builder status(ApplicationVersionStatus var1);
    }
}

