/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheResponse;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNode;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNodeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReservedCacheNodesResponse
extends ElastiCacheResponse
implements ToCopyableBuilder<Builder, DescribeReservedCacheNodesResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReservedCacheNodesResponse.getter(DescribeReservedCacheNodesResponse::marker)).setter(DescribeReservedCacheNodesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<ReservedCacheNode>> RESERVED_CACHE_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeReservedCacheNodesResponse.getter(DescribeReservedCacheNodesResponse::reservedCacheNodes)).setter(DescribeReservedCacheNodesResponse.setter(Builder::reservedCacheNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedCacheNodes").build(), ListTrait.builder().memberLocationName("ReservedCacheNode").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservedCacheNode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedCacheNode").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, RESERVED_CACHE_NODES_FIELD));
    private final String marker;
    private final List<ReservedCacheNode> reservedCacheNodes;

    private DescribeReservedCacheNodesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.reservedCacheNodes = builder.reservedCacheNodes;
    }

    public String marker() {
        return this.marker;
    }

    public List<ReservedCacheNode> reservedCacheNodes() {
        return this.reservedCacheNodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedCacheNodes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedCacheNodesResponse)) {
            return false;
        }
        DescribeReservedCacheNodesResponse other = (DescribeReservedCacheNodesResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.reservedCacheNodes(), other.reservedCacheNodes());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReservedCacheNodesResponse").add("Marker", (Object)this.marker()).add("ReservedCacheNodes", this.reservedCacheNodes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "ReservedCacheNodes": {
                return Optional.ofNullable(clazz.cast(this.reservedCacheNodes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedCacheNodesResponse, T> g) {
        return obj -> g.apply((DescribeReservedCacheNodesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ReservedCacheNode> reservedCacheNodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedCacheNodesResponse model) {
            super(model);
            this.marker(model.marker);
            this.reservedCacheNodes(model.reservedCacheNodes);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ReservedCacheNode.Builder> getReservedCacheNodes() {
            return this.reservedCacheNodes != null ? (Collection)this.reservedCacheNodes.stream().map(ReservedCacheNode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedCacheNodes(Collection<ReservedCacheNode> reservedCacheNodes) {
            this.reservedCacheNodes = ReservedCacheNodeListCopier.copy(reservedCacheNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedCacheNodes(ReservedCacheNode ... reservedCacheNodes) {
            this.reservedCacheNodes(Arrays.asList(reservedCacheNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedCacheNodes(Consumer<ReservedCacheNode.Builder> ... reservedCacheNodes) {
            this.reservedCacheNodes(Stream.of(reservedCacheNodes).map(c -> (ReservedCacheNode)((ReservedCacheNode.Builder)ReservedCacheNode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReservedCacheNodes(Collection<ReservedCacheNode.BuilderImpl> reservedCacheNodes) {
            this.reservedCacheNodes = ReservedCacheNodeListCopier.copyFromBuilder(reservedCacheNodes);
        }

        @Override
        public DescribeReservedCacheNodesResponse build() {
            return new DescribeReservedCacheNodesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElastiCacheResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReservedCacheNodesResponse> {
        public Builder marker(String var1);

        public Builder reservedCacheNodes(Collection<ReservedCacheNode> var1);

        public Builder reservedCacheNodes(ReservedCacheNode ... var1);

        public Builder reservedCacheNodes(Consumer<ReservedCacheNode.Builder> ... var1);
    }
}

