/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.Authentication;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheResponse;
import software.amazon.awssdk.services.elasticache.model.UserGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyUserResponse
extends ElastiCacheResponse
implements ToCopyableBuilder<Builder, ModifyUserResponse> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(ModifyUserResponse.getter(ModifyUserResponse::userId)).setter(ModifyUserResponse.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(ModifyUserResponse.getter(ModifyUserResponse::userName)).setter(ModifyUserResponse.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ModifyUserResponse.getter(ModifyUserResponse::status)).setter(ModifyUserResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(ModifyUserResponse.getter(ModifyUserResponse::engine)).setter(ModifyUserResponse.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> MINIMUM_ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MinimumEngineVersion").getter(ModifyUserResponse.getter(ModifyUserResponse::minimumEngineVersion)).setter(ModifyUserResponse.setter(Builder::minimumEngineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumEngineVersion").build()}).build();
    private static final SdkField<String> ACCESS_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessString").getter(ModifyUserResponse.getter(ModifyUserResponse::accessString)).setter(ModifyUserResponse.setter(Builder::accessString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessString").build()}).build();
    private static final SdkField<List<String>> USER_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserGroupIds").getter(ModifyUserResponse.getter(ModifyUserResponse::userGroupIds)).setter(ModifyUserResponse.setter(Builder::userGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Authentication> AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Authentication").getter(ModifyUserResponse.getter(ModifyUserResponse::authentication)).setter(ModifyUserResponse.setter(Builder::authentication)).constructor(Authentication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Authentication").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(ModifyUserResponse.getter(ModifyUserResponse::arn)).setter(ModifyUserResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD, USER_NAME_FIELD, STATUS_FIELD, ENGINE_FIELD, MINIMUM_ENGINE_VERSION_FIELD, ACCESS_STRING_FIELD, USER_GROUP_IDS_FIELD, AUTHENTICATION_FIELD, ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyUserResponse.memberNameToFieldInitializer();
    private final String userId;
    private final String userName;
    private final String status;
    private final String engine;
    private final String minimumEngineVersion;
    private final String accessString;
    private final List<String> userGroupIds;
    private final Authentication authentication;
    private final String arn;

    private ModifyUserResponse(BuilderImpl builder) {
        super(builder);
        this.userId = builder.userId;
        this.userName = builder.userName;
        this.status = builder.status;
        this.engine = builder.engine;
        this.minimumEngineVersion = builder.minimumEngineVersion;
        this.accessString = builder.accessString;
        this.userGroupIds = builder.userGroupIds;
        this.authentication = builder.authentication;
        this.arn = builder.arn;
    }

    public final String userId() {
        return this.userId;
    }

    public final String userName() {
        return this.userName;
    }

    public final String status() {
        return this.status;
    }

    public final String engine() {
        return this.engine;
    }

    public final String minimumEngineVersion() {
        return this.minimumEngineVersion;
    }

    public final String accessString() {
        return this.accessString;
    }

    public final boolean hasUserGroupIds() {
        return this.userGroupIds != null && !(this.userGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> userGroupIds() {
        return this.userGroupIds;
    }

    public final Authentication authentication() {
        return this.authentication;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserGroupIds() ? this.userGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.authentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyUserResponse)) {
            return false;
        }
        ModifyUserResponse other = (ModifyUserResponse)((Object)obj);
        return Objects.equals(this.userId(), other.userId()) && Objects.equals(this.userName(), other.userName()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.minimumEngineVersion(), other.minimumEngineVersion()) && Objects.equals(this.accessString(), other.accessString()) && this.hasUserGroupIds() == other.hasUserGroupIds() && Objects.equals(this.userGroupIds(), other.userGroupIds()) && Objects.equals(this.authentication(), other.authentication()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyUserResponse").add("UserId", (Object)this.userId()).add("UserName", (Object)this.userName()).add("Status", (Object)this.status()).add("Engine", (Object)this.engine()).add("MinimumEngineVersion", (Object)this.minimumEngineVersion()).add("AccessString", (Object)this.accessString()).add("UserGroupIds", this.hasUserGroupIds() ? this.userGroupIds() : null).add("Authentication", (Object)this.authentication()).add("ARN", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "MinimumEngineVersion": {
                return Optional.ofNullable(clazz.cast(this.minimumEngineVersion()));
            }
            case "AccessString": {
                return Optional.ofNullable(clazz.cast(this.accessString()));
            }
            case "UserGroupIds": {
                return Optional.ofNullable(clazz.cast(this.userGroupIds()));
            }
            case "Authentication": {
                return Optional.ofNullable(clazz.cast(this.authentication()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UserId", USER_ID_FIELD);
        map.put("UserName", USER_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Engine", ENGINE_FIELD);
        map.put("MinimumEngineVersion", MINIMUM_ENGINE_VERSION_FIELD);
        map.put("AccessString", ACCESS_STRING_FIELD);
        map.put("UserGroupIds", USER_GROUP_IDS_FIELD);
        map.put("Authentication", AUTHENTICATION_FIELD);
        map.put("ARN", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyUserResponse, T> g) {
        return obj -> g.apply((ModifyUserResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheResponse.BuilderImpl
    implements Builder {
        private String userId;
        private String userName;
        private String status;
        private String engine;
        private String minimumEngineVersion;
        private String accessString;
        private List<String> userGroupIds = DefaultSdkAutoConstructList.getInstance();
        private Authentication authentication;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyUserResponse model) {
            super(model);
            this.userId(model.userId);
            this.userName(model.userName);
            this.status(model.status);
            this.engine(model.engine);
            this.minimumEngineVersion(model.minimumEngineVersion);
            this.accessString(model.accessString);
            this.userGroupIds(model.userGroupIds);
            this.authentication(model.authentication);
            this.arn(model.arn);
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getMinimumEngineVersion() {
            return this.minimumEngineVersion;
        }

        public final void setMinimumEngineVersion(String minimumEngineVersion) {
            this.minimumEngineVersion = minimumEngineVersion;
        }

        @Override
        public final Builder minimumEngineVersion(String minimumEngineVersion) {
            this.minimumEngineVersion = minimumEngineVersion;
            return this;
        }

        public final String getAccessString() {
            return this.accessString;
        }

        public final void setAccessString(String accessString) {
            this.accessString = accessString;
        }

        @Override
        public final Builder accessString(String accessString) {
            this.accessString = accessString;
            return this;
        }

        public final Collection<String> getUserGroupIds() {
            if (this.userGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userGroupIds;
        }

        public final void setUserGroupIds(Collection<String> userGroupIds) {
            this.userGroupIds = UserGroupIdListCopier.copy(userGroupIds);
        }

        @Override
        public final Builder userGroupIds(Collection<String> userGroupIds) {
            this.userGroupIds = UserGroupIdListCopier.copy(userGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroupIds(String ... userGroupIds) {
            this.userGroupIds(Arrays.asList(userGroupIds));
            return this;
        }

        public final Authentication.Builder getAuthentication() {
            return this.authentication != null ? this.authentication.toBuilder() : null;
        }

        public final void setAuthentication(Authentication.BuilderImpl authentication) {
            this.authentication = authentication != null ? authentication.build() : null;
        }

        @Override
        public final Builder authentication(Authentication authentication) {
            this.authentication = authentication;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public ModifyUserResponse build() {
            return new ModifyUserResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ElastiCacheResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyUserResponse> {
        public Builder userId(String var1);

        public Builder userName(String var1);

        public Builder status(String var1);

        public Builder engine(String var1);

        public Builder minimumEngineVersion(String var1);

        public Builder accessString(String var1);

        public Builder userGroupIds(Collection<String> var1);

        public Builder userGroupIds(String ... var1);

        public Builder authentication(Authentication var1);

        default public Builder authentication(Consumer<Authentication.Builder> authentication) {
            return this.authentication((Authentication)((Authentication.Builder)Authentication.builder().applyMutation(authentication)).build());
        }

        public Builder arn(String var1);
    }
}

