/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.ParameterNameValue;
import software.amazon.awssdk.services.elasticache.model.ParameterNameValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResetCacheParameterGroupRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, ResetCacheParameterGroupRequest> {
    private static final SdkField<String> CACHE_PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheParameterGroupName").getter(ResetCacheParameterGroupRequest.getter(ResetCacheParameterGroupRequest::cacheParameterGroupName)).setter(ResetCacheParameterGroupRequest.setter(Builder::cacheParameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroupName").build()}).build();
    private static final SdkField<Boolean> RESET_ALL_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ResetAllParameters").getter(ResetCacheParameterGroupRequest.getter(ResetCacheParameterGroupRequest::resetAllParameters)).setter(ResetCacheParameterGroupRequest.setter(Builder::resetAllParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResetAllParameters").build()}).build();
    private static final SdkField<List<ParameterNameValue>> PARAMETER_NAME_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ParameterNameValues").getter(ResetCacheParameterGroupRequest.getter(ResetCacheParameterGroupRequest::parameterNameValues)).setter(ResetCacheParameterGroupRequest.setter(Builder::parameterNameValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterNameValues").build(), ListTrait.builder().memberLocationName("ParameterNameValue").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParameterNameValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterNameValue").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_PARAMETER_GROUP_NAME_FIELD, RESET_ALL_PARAMETERS_FIELD, PARAMETER_NAME_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResetCacheParameterGroupRequest.memberNameToFieldInitializer();
    private final String cacheParameterGroupName;
    private final Boolean resetAllParameters;
    private final List<ParameterNameValue> parameterNameValues;

    private ResetCacheParameterGroupRequest(BuilderImpl builder) {
        super(builder);
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.resetAllParameters = builder.resetAllParameters;
        this.parameterNameValues = builder.parameterNameValues;
    }

    public final String cacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public final Boolean resetAllParameters() {
        return this.resetAllParameters;
    }

    public final boolean hasParameterNameValues() {
        return this.parameterNameValues != null && !(this.parameterNameValues instanceof SdkAutoConstructList);
    }

    public final List<ParameterNameValue> parameterNameValues() {
        return this.parameterNameValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resetAllParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameterNameValues() ? this.parameterNameValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetCacheParameterGroupRequest)) {
            return false;
        }
        ResetCacheParameterGroupRequest other = (ResetCacheParameterGroupRequest)((Object)obj);
        return Objects.equals(this.cacheParameterGroupName(), other.cacheParameterGroupName()) && Objects.equals(this.resetAllParameters(), other.resetAllParameters()) && this.hasParameterNameValues() == other.hasParameterNameValues() && Objects.equals(this.parameterNameValues(), other.parameterNameValues());
    }

    public final String toString() {
        return ToString.builder((String)"ResetCacheParameterGroupRequest").add("CacheParameterGroupName", (Object)this.cacheParameterGroupName()).add("ResetAllParameters", (Object)this.resetAllParameters()).add("ParameterNameValues", this.hasParameterNameValues() ? this.parameterNameValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.cacheParameterGroupName()));
            }
            case "ResetAllParameters": {
                return Optional.ofNullable(clazz.cast(this.resetAllParameters()));
            }
            case "ParameterNameValues": {
                return Optional.ofNullable(clazz.cast(this.parameterNameValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CacheParameterGroupName", CACHE_PARAMETER_GROUP_NAME_FIELD);
        map.put("ResetAllParameters", RESET_ALL_PARAMETERS_FIELD);
        map.put("ParameterNameValues", PARAMETER_NAME_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResetCacheParameterGroupRequest, T> g) {
        return obj -> g.apply((ResetCacheParameterGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String cacheParameterGroupName;
        private Boolean resetAllParameters;
        private List<ParameterNameValue> parameterNameValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResetCacheParameterGroupRequest model) {
            super(model);
            this.cacheParameterGroupName(model.cacheParameterGroupName);
            this.resetAllParameters(model.resetAllParameters);
            this.parameterNameValues(model.parameterNameValues);
        }

        public final String getCacheParameterGroupName() {
            return this.cacheParameterGroupName;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final Boolean getResetAllParameters() {
            return this.resetAllParameters;
        }

        public final void setResetAllParameters(Boolean resetAllParameters) {
            this.resetAllParameters = resetAllParameters;
        }

        @Override
        public final Builder resetAllParameters(Boolean resetAllParameters) {
            this.resetAllParameters = resetAllParameters;
            return this;
        }

        public final List<ParameterNameValue.Builder> getParameterNameValues() {
            List<ParameterNameValue.Builder> result = ParameterNameValueListCopier.copyToBuilder(this.parameterNameValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameterNameValues(Collection<ParameterNameValue.BuilderImpl> parameterNameValues) {
            this.parameterNameValues = ParameterNameValueListCopier.copyFromBuilder(parameterNameValues);
        }

        @Override
        public final Builder parameterNameValues(Collection<ParameterNameValue> parameterNameValues) {
            this.parameterNameValues = ParameterNameValueListCopier.copy(parameterNameValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterNameValues(ParameterNameValue ... parameterNameValues) {
            this.parameterNameValues(Arrays.asList(parameterNameValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterNameValues(Consumer<ParameterNameValue.Builder> ... parameterNameValues) {
            this.parameterNameValues(Stream.of(parameterNameValues).map(c -> (ParameterNameValue)((ParameterNameValue.Builder)ParameterNameValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResetCacheParameterGroupRequest build() {
            return new ResetCacheParameterGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ResetCacheParameterGroupRequest> {
        public Builder cacheParameterGroupName(String var1);

        public Builder resetAllParameters(Boolean var1);

        public Builder parameterNameValues(Collection<ParameterNameValue> var1);

        public Builder parameterNameValues(ParameterNameValue ... var1);

        public Builder parameterNameValues(Consumer<ParameterNameValue.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

