/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticache.model.UpdateActionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProcessedUpdateAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProcessedUpdateAction> {
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationGroupId").getter(ProcessedUpdateAction.getter(ProcessedUpdateAction::replicationGroupId)).setter(ProcessedUpdateAction.setter(Builder::replicationGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build()}).build();
    private static final SdkField<String> CACHE_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheClusterId").getter(ProcessedUpdateAction.getter(ProcessedUpdateAction::cacheClusterId)).setter(ProcessedUpdateAction.setter(Builder::cacheClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterId").build()}).build();
    private static final SdkField<String> SERVICE_UPDATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceUpdateName").getter(ProcessedUpdateAction.getter(ProcessedUpdateAction::serviceUpdateName)).setter(ProcessedUpdateAction.setter(Builder::serviceUpdateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateName").build()}).build();
    private static final SdkField<String> UPDATE_ACTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateActionStatus").getter(ProcessedUpdateAction.getter(ProcessedUpdateAction::updateActionStatusAsString)).setter(ProcessedUpdateAction.setter(Builder::updateActionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateActionStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_ID_FIELD, CACHE_CLUSTER_ID_FIELD, SERVICE_UPDATE_NAME_FIELD, UPDATE_ACTION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ReplicationGroupId", REPLICATION_GROUP_ID_FIELD);
            this.put("CacheClusterId", CACHE_CLUSTER_ID_FIELD);
            this.put("ServiceUpdateName", SERVICE_UPDATE_NAME_FIELD);
            this.put("UpdateActionStatus", UPDATE_ACTION_STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String replicationGroupId;
    private final String cacheClusterId;
    private final String serviceUpdateName;
    private final String updateActionStatus;

    private ProcessedUpdateAction(BuilderImpl builder) {
        this.replicationGroupId = builder.replicationGroupId;
        this.cacheClusterId = builder.cacheClusterId;
        this.serviceUpdateName = builder.serviceUpdateName;
        this.updateActionStatus = builder.updateActionStatus;
    }

    public final String replicationGroupId() {
        return this.replicationGroupId;
    }

    public final String cacheClusterId() {
        return this.cacheClusterId;
    }

    public final String serviceUpdateName() {
        return this.serviceUpdateName;
    }

    public final UpdateActionStatus updateActionStatus() {
        return UpdateActionStatus.fromValue(this.updateActionStatus);
    }

    public final String updateActionStatusAsString() {
        return this.updateActionStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceUpdateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateActionStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessedUpdateAction)) {
            return false;
        }
        ProcessedUpdateAction other = (ProcessedUpdateAction)obj;
        return Objects.equals(this.replicationGroupId(), other.replicationGroupId()) && Objects.equals(this.cacheClusterId(), other.cacheClusterId()) && Objects.equals(this.serviceUpdateName(), other.serviceUpdateName()) && Objects.equals(this.updateActionStatusAsString(), other.updateActionStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ProcessedUpdateAction").add("ReplicationGroupId", (Object)this.replicationGroupId()).add("CacheClusterId", (Object)this.cacheClusterId()).add("ServiceUpdateName", (Object)this.serviceUpdateName()).add("UpdateActionStatus", (Object)this.updateActionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationGroupId": {
                return Optional.ofNullable(clazz.cast(this.replicationGroupId()));
            }
            case "CacheClusterId": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterId()));
            }
            case "ServiceUpdateName": {
                return Optional.ofNullable(clazz.cast(this.serviceUpdateName()));
            }
            case "UpdateActionStatus": {
                return Optional.ofNullable(clazz.cast(this.updateActionStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ProcessedUpdateAction, T> g) {
        return obj -> g.apply((ProcessedUpdateAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String replicationGroupId;
        private String cacheClusterId;
        private String serviceUpdateName;
        private String updateActionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessedUpdateAction model) {
            this.replicationGroupId(model.replicationGroupId);
            this.cacheClusterId(model.cacheClusterId);
            this.serviceUpdateName(model.serviceUpdateName);
            this.updateActionStatus(model.updateActionStatus);
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final String getCacheClusterId() {
            return this.cacheClusterId;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final String getServiceUpdateName() {
            return this.serviceUpdateName;
        }

        public final void setServiceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
        }

        @Override
        public final Builder serviceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
            return this;
        }

        public final String getUpdateActionStatus() {
            return this.updateActionStatus;
        }

        public final void setUpdateActionStatus(String updateActionStatus) {
            this.updateActionStatus = updateActionStatus;
        }

        @Override
        public final Builder updateActionStatus(String updateActionStatus) {
            this.updateActionStatus = updateActionStatus;
            return this;
        }

        @Override
        public final Builder updateActionStatus(UpdateActionStatus updateActionStatus) {
            this.updateActionStatus(updateActionStatus == null ? null : updateActionStatus.toString());
            return this;
        }

        public ProcessedUpdateAction build() {
            return new ProcessedUpdateAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProcessedUpdateAction> {
        public Builder replicationGroupId(String var1);

        public Builder cacheClusterId(String var1);

        public Builder serviceUpdateName(String var1);

        public Builder updateActionStatus(String var1);

        public Builder updateActionStatus(UpdateActionStatus var1);
    }
}

