/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheResponse;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroup;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReplicationGroupsResponse
extends ElastiCacheResponse
implements ToCopyableBuilder<Builder, DescribeReplicationGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeReplicationGroupsResponse.getter(DescribeReplicationGroupsResponse::marker)).setter(DescribeReplicationGroupsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<ReplicationGroup>> REPLICATION_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicationGroups").getter(DescribeReplicationGroupsResponse.getter(DescribeReplicationGroupsResponse::replicationGroups)).setter(DescribeReplicationGroupsResponse.setter(Builder::replicationGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroups").build(), ListTrait.builder().memberLocationName("ReplicationGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicationGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroup").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, REPLICATION_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Marker", MARKER_FIELD);
            this.put("ReplicationGroups", REPLICATION_GROUPS_FIELD);
        }
    });
    private final String marker;
    private final List<ReplicationGroup> replicationGroups;

    private DescribeReplicationGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.replicationGroups = builder.replicationGroups;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasReplicationGroups() {
        return this.replicationGroups != null && !(this.replicationGroups instanceof SdkAutoConstructList);
    }

    public final List<ReplicationGroup> replicationGroups() {
        return this.replicationGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationGroups() ? this.replicationGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationGroupsResponse)) {
            return false;
        }
        DescribeReplicationGroupsResponse other = (DescribeReplicationGroupsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasReplicationGroups() == other.hasReplicationGroups() && Objects.equals(this.replicationGroups(), other.replicationGroups());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeReplicationGroupsResponse").add("Marker", (Object)this.marker()).add("ReplicationGroups", this.hasReplicationGroups() ? this.replicationGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "ReplicationGroups": {
                return Optional.ofNullable(clazz.cast(this.replicationGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplicationGroupsResponse, T> g) {
        return obj -> g.apply((DescribeReplicationGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ReplicationGroup> replicationGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationGroupsResponse model) {
            super(model);
            this.marker(model.marker);
            this.replicationGroups(model.replicationGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<ReplicationGroup.Builder> getReplicationGroups() {
            List<ReplicationGroup.Builder> result = ReplicationGroupListCopier.copyToBuilder(this.replicationGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationGroups(Collection<ReplicationGroup.BuilderImpl> replicationGroups) {
            this.replicationGroups = ReplicationGroupListCopier.copyFromBuilder(replicationGroups);
        }

        @Override
        public final Builder replicationGroups(Collection<ReplicationGroup> replicationGroups) {
            this.replicationGroups = ReplicationGroupListCopier.copy(replicationGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroups(ReplicationGroup ... replicationGroups) {
            this.replicationGroups(Arrays.asList(replicationGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroups(Consumer<ReplicationGroup.Builder> ... replicationGroups) {
            this.replicationGroups(Stream.of(replicationGroups).map(c -> (ReplicationGroup)((ReplicationGroup.Builder)ReplicationGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeReplicationGroupsResponse build() {
            return new DescribeReplicationGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElastiCacheResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReplicationGroupsResponse> {
        public Builder marker(String var1);

        public Builder replicationGroups(Collection<ReplicationGroup> var1);

        public Builder replicationGroups(ReplicationGroup ... var1);

        public Builder replicationGroups(Consumer<ReplicationGroup.Builder> ... var1);
    }
}

