/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.AuthenticationMode;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.PasswordListInputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyUserRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, ModifyUserRequest> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(ModifyUserRequest.getter(ModifyUserRequest::userId)).setter(ModifyUserRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<String> ACCESS_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessString").getter(ModifyUserRequest.getter(ModifyUserRequest::accessString)).setter(ModifyUserRequest.setter(Builder::accessString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessString").build()}).build();
    private static final SdkField<String> APPEND_ACCESS_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppendAccessString").getter(ModifyUserRequest.getter(ModifyUserRequest::appendAccessString)).setter(ModifyUserRequest.setter(Builder::appendAccessString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppendAccessString").build()}).build();
    private static final SdkField<List<String>> PASSWORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Passwords").getter(ModifyUserRequest.getter(ModifyUserRequest::passwords)).setter(ModifyUserRequest.setter(Builder::passwords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Passwords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> NO_PASSWORD_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NoPasswordRequired").getter(ModifyUserRequest.getter(ModifyUserRequest::noPasswordRequired)).setter(ModifyUserRequest.setter(Builder::noPasswordRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoPasswordRequired").build()}).build();
    private static final SdkField<AuthenticationMode> AUTHENTICATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuthenticationMode").getter(ModifyUserRequest.getter(ModifyUserRequest::authenticationMode)).setter(ModifyUserRequest.setter(Builder::authenticationMode)).constructor(AuthenticationMode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationMode").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(ModifyUserRequest.getter(ModifyUserRequest::engine)).setter(ModifyUserRequest.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD, ACCESS_STRING_FIELD, APPEND_ACCESS_STRING_FIELD, PASSWORDS_FIELD, NO_PASSWORD_REQUIRED_FIELD, AUTHENTICATION_MODE_FIELD, ENGINE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("UserId", USER_ID_FIELD);
            this.put("AccessString", ACCESS_STRING_FIELD);
            this.put("AppendAccessString", APPEND_ACCESS_STRING_FIELD);
            this.put("Passwords", PASSWORDS_FIELD);
            this.put("NoPasswordRequired", NO_PASSWORD_REQUIRED_FIELD);
            this.put("AuthenticationMode", AUTHENTICATION_MODE_FIELD);
            this.put("Engine", ENGINE_FIELD);
        }
    });
    private final String userId;
    private final String accessString;
    private final String appendAccessString;
    private final List<String> passwords;
    private final Boolean noPasswordRequired;
    private final AuthenticationMode authenticationMode;
    private final String engine;

    private ModifyUserRequest(BuilderImpl builder) {
        super(builder);
        this.userId = builder.userId;
        this.accessString = builder.accessString;
        this.appendAccessString = builder.appendAccessString;
        this.passwords = builder.passwords;
        this.noPasswordRequired = builder.noPasswordRequired;
        this.authenticationMode = builder.authenticationMode;
        this.engine = builder.engine;
    }

    public final String userId() {
        return this.userId;
    }

    public final String accessString() {
        return this.accessString;
    }

    public final String appendAccessString() {
        return this.appendAccessString;
    }

    public final boolean hasPasswords() {
        return this.passwords != null && !(this.passwords instanceof SdkAutoConstructList);
    }

    public final List<String> passwords() {
        return this.passwords;
    }

    public final Boolean noPasswordRequired() {
        return this.noPasswordRequired;
    }

    public final AuthenticationMode authenticationMode() {
        return this.authenticationMode;
    }

    public final String engine() {
        return this.engine;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessString());
        hashCode = 31 * hashCode + Objects.hashCode(this.appendAccessString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPasswords() ? this.passwords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.noPasswordRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyUserRequest)) {
            return false;
        }
        ModifyUserRequest other = (ModifyUserRequest)((Object)obj);
        return Objects.equals(this.userId(), other.userId()) && Objects.equals(this.accessString(), other.accessString()) && Objects.equals(this.appendAccessString(), other.appendAccessString()) && this.hasPasswords() == other.hasPasswords() && Objects.equals(this.passwords(), other.passwords()) && Objects.equals(this.noPasswordRequired(), other.noPasswordRequired()) && Objects.equals(this.authenticationMode(), other.authenticationMode()) && Objects.equals(this.engine(), other.engine());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyUserRequest").add("UserId", (Object)this.userId()).add("AccessString", (Object)this.accessString()).add("AppendAccessString", (Object)this.appendAccessString()).add("Passwords", this.hasPasswords() ? this.passwords() : null).add("NoPasswordRequired", (Object)this.noPasswordRequired()).add("AuthenticationMode", (Object)this.authenticationMode()).add("Engine", (Object)this.engine()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "AccessString": {
                return Optional.ofNullable(clazz.cast(this.accessString()));
            }
            case "AppendAccessString": {
                return Optional.ofNullable(clazz.cast(this.appendAccessString()));
            }
            case "Passwords": {
                return Optional.ofNullable(clazz.cast(this.passwords()));
            }
            case "NoPasswordRequired": {
                return Optional.ofNullable(clazz.cast(this.noPasswordRequired()));
            }
            case "AuthenticationMode": {
                return Optional.ofNullable(clazz.cast(this.authenticationMode()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModifyUserRequest, T> g) {
        return obj -> g.apply((ModifyUserRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String userId;
        private String accessString;
        private String appendAccessString;
        private List<String> passwords = DefaultSdkAutoConstructList.getInstance();
        private Boolean noPasswordRequired;
        private AuthenticationMode authenticationMode;
        private String engine;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyUserRequest model) {
            super(model);
            this.userId(model.userId);
            this.accessString(model.accessString);
            this.appendAccessString(model.appendAccessString);
            this.passwords(model.passwords);
            this.noPasswordRequired(model.noPasswordRequired);
            this.authenticationMode(model.authenticationMode);
            this.engine(model.engine);
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getAccessString() {
            return this.accessString;
        }

        public final void setAccessString(String accessString) {
            this.accessString = accessString;
        }

        @Override
        public final Builder accessString(String accessString) {
            this.accessString = accessString;
            return this;
        }

        public final String getAppendAccessString() {
            return this.appendAccessString;
        }

        public final void setAppendAccessString(String appendAccessString) {
            this.appendAccessString = appendAccessString;
        }

        @Override
        public final Builder appendAccessString(String appendAccessString) {
            this.appendAccessString = appendAccessString;
            return this;
        }

        public final Collection<String> getPasswords() {
            if (this.passwords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.passwords;
        }

        public final void setPasswords(Collection<String> passwords) {
            this.passwords = PasswordListInputCopier.copy(passwords);
        }

        @Override
        public final Builder passwords(Collection<String> passwords) {
            this.passwords = PasswordListInputCopier.copy(passwords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder passwords(String ... passwords) {
            this.passwords(Arrays.asList(passwords));
            return this;
        }

        public final Boolean getNoPasswordRequired() {
            return this.noPasswordRequired;
        }

        public final void setNoPasswordRequired(Boolean noPasswordRequired) {
            this.noPasswordRequired = noPasswordRequired;
        }

        @Override
        public final Builder noPasswordRequired(Boolean noPasswordRequired) {
            this.noPasswordRequired = noPasswordRequired;
            return this;
        }

        public final AuthenticationMode.Builder getAuthenticationMode() {
            return this.authenticationMode != null ? this.authenticationMode.toBuilder() : null;
        }

        public final void setAuthenticationMode(AuthenticationMode.BuilderImpl authenticationMode) {
            this.authenticationMode = authenticationMode != null ? authenticationMode.build() : null;
        }

        @Override
        public final Builder authenticationMode(AuthenticationMode authenticationMode) {
            this.authenticationMode = authenticationMode;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyUserRequest build() {
            return new ModifyUserRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyUserRequest> {
        public Builder userId(String var1);

        public Builder accessString(String var1);

        public Builder appendAccessString(String var1);

        public Builder passwords(Collection<String> var1);

        public Builder passwords(String ... var1);

        public Builder noPasswordRequired(Boolean var1);

        public Builder authenticationMode(AuthenticationMode var1);

        default public Builder authenticationMode(Consumer<AuthenticationMode.Builder> authenticationMode) {
            return this.authenticationMode((AuthenticationMode)((AuthenticationMode.Builder)AuthenticationMode.builder().applyMutation(authenticationMode)).build());
        }

        public Builder engine(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

