/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.AvailabilityZonesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReshardingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReshardingConfiguration> {
    private static final SdkField<String> NODE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeGroupId").getter(ReshardingConfiguration.getter(ReshardingConfiguration::nodeGroupId)).setter(ReshardingConfiguration.setter(Builder::nodeGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupId").build()}).build();
    private static final SdkField<List<String>> PREFERRED_AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PreferredAvailabilityZones").getter(ReshardingConfiguration.getter(ReshardingConfiguration::preferredAvailabilityZones)).setter(ReshardingConfiguration.setter(Builder::preferredAvailabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredAvailabilityZones").build(), ListTrait.builder().memberLocationName("AvailabilityZone").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_GROUP_ID_FIELD, PREFERRED_AVAILABILITY_ZONES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String nodeGroupId;
    private final List<String> preferredAvailabilityZones;

    private ReshardingConfiguration(BuilderImpl builder) {
        this.nodeGroupId = builder.nodeGroupId;
        this.preferredAvailabilityZones = builder.preferredAvailabilityZones;
    }

    public final String nodeGroupId() {
        return this.nodeGroupId;
    }

    public final boolean hasPreferredAvailabilityZones() {
        return this.preferredAvailabilityZones != null && !(this.preferredAvailabilityZones instanceof SdkAutoConstructList);
    }

    public final List<String> preferredAvailabilityZones() {
        return this.preferredAvailabilityZones;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPreferredAvailabilityZones() ? this.preferredAvailabilityZones() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReshardingConfiguration)) {
            return false;
        }
        ReshardingConfiguration other = (ReshardingConfiguration)obj;
        return Objects.equals(this.nodeGroupId(), other.nodeGroupId()) && this.hasPreferredAvailabilityZones() == other.hasPreferredAvailabilityZones() && Objects.equals(this.preferredAvailabilityZones(), other.preferredAvailabilityZones());
    }

    public final String toString() {
        return ToString.builder((String)"ReshardingConfiguration").add("NodeGroupId", (Object)this.nodeGroupId()).add("PreferredAvailabilityZones", this.hasPreferredAvailabilityZones() ? this.preferredAvailabilityZones() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NodeGroupId": {
                return Optional.ofNullable(clazz.cast(this.nodeGroupId()));
            }
            case "PreferredAvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.preferredAvailabilityZones()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReshardingConfiguration, T> g) {
        return obj -> g.apply((ReshardingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String nodeGroupId;
        private List<String> preferredAvailabilityZones = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReshardingConfiguration model) {
            this.nodeGroupId(model.nodeGroupId);
            this.preferredAvailabilityZones(model.preferredAvailabilityZones);
        }

        public final String getNodeGroupId() {
            return this.nodeGroupId;
        }

        public final void setNodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
        }

        @Override
        public final Builder nodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
            return this;
        }

        public final Collection<String> getPreferredAvailabilityZones() {
            if (this.preferredAvailabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.preferredAvailabilityZones;
        }

        public final void setPreferredAvailabilityZones(Collection<String> preferredAvailabilityZones) {
            this.preferredAvailabilityZones = AvailabilityZonesListCopier.copy(preferredAvailabilityZones);
        }

        @Override
        public final Builder preferredAvailabilityZones(Collection<String> preferredAvailabilityZones) {
            this.preferredAvailabilityZones = AvailabilityZonesListCopier.copy(preferredAvailabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preferredAvailabilityZones(String ... preferredAvailabilityZones) {
            this.preferredAvailabilityZones(Arrays.asList(preferredAvailabilityZones));
            return this;
        }

        public ReshardingConfiguration build() {
            return new ReshardingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReshardingConfiguration> {
        public Builder nodeGroupId(String var1);

        public Builder preferredAvailabilityZones(Collection<String> var1);

        public Builder preferredAvailabilityZones(String ... var1);
    }
}

