/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.elasticache.ElastiCacheAsyncClient;
import software.amazon.awssdk.services.elasticache.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.waiters.ElastiCacheAsyncWaiter;
import software.amazon.awssdk.services.elasticache.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultElastiCacheAsyncWaiter
implements ElastiCacheAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final ElastiCacheAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeCacheClustersResponse> cacheClusterAvailableWaiter;
    private final AsyncWaiter<DescribeCacheClustersResponse> cacheClusterDeletedWaiter;
    private final AsyncWaiter<DescribeReplicationGroupsResponse> replicationGroupAvailableWaiter;
    private final AsyncWaiter<DescribeReplicationGroupsResponse> replicationGroupDeletedWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultElastiCacheAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (ElastiCacheAsyncClient)ElastiCacheAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.cacheClusterAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeCacheClustersResponse.class).acceptors(DefaultElastiCacheAsyncWaiter.cacheClusterAvailableWaiterAcceptors())).overrideConfiguration(DefaultElastiCacheAsyncWaiter.cacheClusterAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.cacheClusterDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeCacheClustersResponse.class).acceptors(DefaultElastiCacheAsyncWaiter.cacheClusterDeletedWaiterAcceptors())).overrideConfiguration(DefaultElastiCacheAsyncWaiter.cacheClusterDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.replicationGroupAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeReplicationGroupsResponse.class).acceptors(DefaultElastiCacheAsyncWaiter.replicationGroupAvailableWaiterAcceptors())).overrideConfiguration(DefaultElastiCacheAsyncWaiter.replicationGroupAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.replicationGroupDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeReplicationGroupsResponse.class).acceptors(DefaultElastiCacheAsyncWaiter.replicationGroupDeletedWaiterAcceptors())).overrideConfiguration(DefaultElastiCacheAsyncWaiter.replicationGroupDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeCacheClustersResponse>> waitUntilCacheClusterAvailable(DescribeCacheClustersRequest describeCacheClustersRequest) {
        return this.cacheClusterAvailableWaiter.runAsync(() -> this.client.describeCacheClusters(this.applyWaitersUserAgent(describeCacheClustersRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeCacheClustersResponse>> waitUntilCacheClusterAvailable(DescribeCacheClustersRequest describeCacheClustersRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.cacheClusterAvailableWaiter.runAsync(() -> this.client.describeCacheClusters(this.applyWaitersUserAgent(describeCacheClustersRequest)), DefaultElastiCacheAsyncWaiter.cacheClusterAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeCacheClustersResponse>> waitUntilCacheClusterDeleted(DescribeCacheClustersRequest describeCacheClustersRequest) {
        return this.cacheClusterDeletedWaiter.runAsync(() -> this.client.describeCacheClusters(this.applyWaitersUserAgent(describeCacheClustersRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeCacheClustersResponse>> waitUntilCacheClusterDeleted(DescribeCacheClustersRequest describeCacheClustersRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.cacheClusterDeletedWaiter.runAsync(() -> this.client.describeCacheClusters(this.applyWaitersUserAgent(describeCacheClustersRequest)), DefaultElastiCacheAsyncWaiter.cacheClusterDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeReplicationGroupsResponse>> waitUntilReplicationGroupAvailable(DescribeReplicationGroupsRequest describeReplicationGroupsRequest) {
        return this.replicationGroupAvailableWaiter.runAsync(() -> this.client.describeReplicationGroups(this.applyWaitersUserAgent(describeReplicationGroupsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeReplicationGroupsResponse>> waitUntilReplicationGroupAvailable(DescribeReplicationGroupsRequest describeReplicationGroupsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.replicationGroupAvailableWaiter.runAsync(() -> this.client.describeReplicationGroups(this.applyWaitersUserAgent(describeReplicationGroupsRequest)), DefaultElastiCacheAsyncWaiter.replicationGroupAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeReplicationGroupsResponse>> waitUntilReplicationGroupDeleted(DescribeReplicationGroupsRequest describeReplicationGroupsRequest) {
        return this.replicationGroupDeletedWaiter.runAsync(() -> this.client.describeReplicationGroups(this.applyWaitersUserAgent(describeReplicationGroupsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeReplicationGroupsResponse>> waitUntilReplicationGroupDeleted(DescribeReplicationGroupsRequest describeReplicationGroupsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.replicationGroupDeletedWaiter.runAsync(() -> this.client.describeReplicationGroups(this.applyWaitersUserAgent(describeReplicationGroupsRequest)), DefaultElastiCacheAsyncWaiter.replicationGroupDeletedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeCacheClustersResponse>> cacheClusterAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeCacheClustersResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeCacheClustersResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("CacheClusters").flatten().field("CacheClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("CacheClusters").flatten().field("CacheClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (CacheClusters[].CacheClusterStatus=deleted) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("CacheClusters").flatten().field("CacheClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (CacheClusters[].CacheClusterStatus=deleting) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("CacheClusters").flatten().field("CacheClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "incompatible-network"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (CacheClusters[].CacheClusterStatus=incompatible-network) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("CacheClusters").flatten().field("CacheClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "restore-failed"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (CacheClusters[].CacheClusterStatus=restore-failed) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeCacheClustersResponse>> cacheClusterDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeCacheClustersResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeCacheClustersResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("CacheClusters").flatten().field("CacheClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultElastiCacheAsyncWaiter.errorCode(error), "CacheClusterNotFound")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("CacheClusters").flatten().field("CacheClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "available"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (CacheClusters[].CacheClusterStatus=available) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("CacheClusters").flatten().field("CacheClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "creating"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (CacheClusters[].CacheClusterStatus=creating) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("CacheClusters").flatten().field("CacheClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "incompatible-network"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (CacheClusters[].CacheClusterStatus=incompatible-network) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("CacheClusters").flatten().field("CacheClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "modifying"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (CacheClusters[].CacheClusterStatus=modifying) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("CacheClusters").flatten().field("CacheClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "restore-failed"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (CacheClusters[].CacheClusterStatus=restore-failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("CacheClusters").flatten().field("CacheClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "snapshotting"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (CacheClusters[].CacheClusterStatus=snapshotting) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeReplicationGroupsResponse>> replicationGroupAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeReplicationGroupsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeReplicationGroupsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationGroups").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationGroups").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationGroups[].Status=deleted) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeReplicationGroupsResponse>> replicationGroupDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeReplicationGroupsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeReplicationGroupsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationGroups").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationGroups").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "available"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationGroups[].Status=available) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultElastiCacheAsyncWaiter.errorCode(error), "ReplicationGroupNotFoundFault")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration cacheClusterAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration cacheClusterDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration replicationGroupAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration replicationGroupDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static ElastiCacheAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends ElastiCacheRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ElastiCacheRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements ElastiCacheAsyncWaiter.Builder {
        private ElastiCacheAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public ElastiCacheAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public ElastiCacheAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public ElastiCacheAsyncWaiter.Builder client(ElastiCacheAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public ElastiCacheAsyncWaiter build() {
            return new DefaultElastiCacheAsyncWaiter(this);
        }
    }
}

