/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticache.ElastiCacheAsyncClient;
import software.amazon.awssdk.services.elasticache.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticache.model.DescribeServerlessCacheSnapshotsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeServerlessCacheSnapshotsResponse;
import software.amazon.awssdk.services.elasticache.model.ServerlessCacheSnapshot;

public class DescribeServerlessCacheSnapshotsPublisher
implements SdkPublisher<DescribeServerlessCacheSnapshotsResponse> {
    private final ElastiCacheAsyncClient client;
    private final DescribeServerlessCacheSnapshotsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeServerlessCacheSnapshotsPublisher(ElastiCacheAsyncClient client, DescribeServerlessCacheSnapshotsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeServerlessCacheSnapshotsPublisher(ElastiCacheAsyncClient client, DescribeServerlessCacheSnapshotsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeServerlessCacheSnapshotsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeServerlessCacheSnapshotsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServerlessCacheSnapshot> serverlessCacheSnapshots() {
        Function<DescribeServerlessCacheSnapshotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.serverlessCacheSnapshots() != null) {
                return response.serverlessCacheSnapshots().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeServerlessCacheSnapshotsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeServerlessCacheSnapshotsResponseFetcher
    implements AsyncPageFetcher<DescribeServerlessCacheSnapshotsResponse> {
        private DescribeServerlessCacheSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeServerlessCacheSnapshotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeServerlessCacheSnapshotsResponse> nextPage(DescribeServerlessCacheSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return DescribeServerlessCacheSnapshotsPublisher.this.client.describeServerlessCacheSnapshots(DescribeServerlessCacheSnapshotsPublisher.this.firstRequest);
            }
            return DescribeServerlessCacheSnapshotsPublisher.this.client.describeServerlessCacheSnapshots((DescribeServerlessCacheSnapshotsRequest)((Object)DescribeServerlessCacheSnapshotsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

