/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesResponse;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNode;

public class DescribeReservedCacheNodesIterable
implements SdkIterable<DescribeReservedCacheNodesResponse> {
    private final ElastiCacheClient client;
    private final DescribeReservedCacheNodesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReservedCacheNodesIterable(ElastiCacheClient client, DescribeReservedCacheNodesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReservedCacheNodesResponseFetcher();
    }

    public Iterator<DescribeReservedCacheNodesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReservedCacheNode> reservedCacheNodes() {
        Function<DescribeReservedCacheNodesResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedCacheNodes() != null) {
                return response.reservedCacheNodes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeReservedCacheNodesResponseFetcher
    implements SyncPageFetcher<DescribeReservedCacheNodesResponse> {
        private DescribeReservedCacheNodesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedCacheNodesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeReservedCacheNodesResponse nextPage(DescribeReservedCacheNodesResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedCacheNodesIterable.this.client.describeReservedCacheNodes(DescribeReservedCacheNodesIterable.this.firstRequest);
            }
            return DescribeReservedCacheNodesIterable.this.client.describeReservedCacheNodes((DescribeReservedCacheNodesRequest)((Object)DescribeReservedCacheNodesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

