/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.RecurringCharge;
import software.amazon.awssdk.services.elasticache.model.RecurringChargeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservedCacheNodesOffering
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservedCacheNodesOffering> {
    private static final SdkField<String> RESERVED_CACHE_NODES_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedCacheNodesOfferingId").getter(ReservedCacheNodesOffering.getter(ReservedCacheNodesOffering::reservedCacheNodesOfferingId)).setter(ReservedCacheNodesOffering.setter(Builder::reservedCacheNodesOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedCacheNodesOfferingId").build()}).build();
    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheNodeType").getter(ReservedCacheNodesOffering.getter(ReservedCacheNodesOffering::cacheNodeType)).setter(ReservedCacheNodesOffering.setter(Builder::cacheNodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()}).build();
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Duration").getter(ReservedCacheNodesOffering.getter(ReservedCacheNodesOffering::duration)).setter(ReservedCacheNodesOffering.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<Double> FIXED_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("FixedPrice").getter(ReservedCacheNodesOffering.getter(ReservedCacheNodesOffering::fixedPrice)).setter(ReservedCacheNodesOffering.setter(Builder::fixedPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedPrice").build()}).build();
    private static final SdkField<Double> USAGE_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("UsagePrice").getter(ReservedCacheNodesOffering.getter(ReservedCacheNodesOffering::usagePrice)).setter(ReservedCacheNodesOffering.setter(Builder::usagePrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsagePrice").build()}).build();
    private static final SdkField<String> PRODUCT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductDescription").getter(ReservedCacheNodesOffering.getter(ReservedCacheNodesOffering::productDescription)).setter(ReservedCacheNodesOffering.setter(Builder::productDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductDescription").build()}).build();
    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferingType").getter(ReservedCacheNodesOffering.getter(ReservedCacheNodesOffering::offeringType)).setter(ReservedCacheNodesOffering.setter(Builder::offeringType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingType").build()}).build();
    private static final SdkField<List<RecurringCharge>> RECURRING_CHARGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecurringCharges").getter(ReservedCacheNodesOffering.getter(ReservedCacheNodesOffering::recurringCharges)).setter(ReservedCacheNodesOffering.setter(Builder::recurringCharges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringCharges").build(), ListTrait.builder().memberLocationName("RecurringCharge").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecurringCharge::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringCharge").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_CACHE_NODES_OFFERING_ID_FIELD, CACHE_NODE_TYPE_FIELD, DURATION_FIELD, FIXED_PRICE_FIELD, USAGE_PRICE_FIELD, PRODUCT_DESCRIPTION_FIELD, OFFERING_TYPE_FIELD, RECURRING_CHARGES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String reservedCacheNodesOfferingId;
    private final String cacheNodeType;
    private final Integer duration;
    private final Double fixedPrice;
    private final Double usagePrice;
    private final String productDescription;
    private final String offeringType;
    private final List<RecurringCharge> recurringCharges;

    private ReservedCacheNodesOffering(BuilderImpl builder) {
        this.reservedCacheNodesOfferingId = builder.reservedCacheNodesOfferingId;
        this.cacheNodeType = builder.cacheNodeType;
        this.duration = builder.duration;
        this.fixedPrice = builder.fixedPrice;
        this.usagePrice = builder.usagePrice;
        this.productDescription = builder.productDescription;
        this.offeringType = builder.offeringType;
        this.recurringCharges = builder.recurringCharges;
    }

    public final String reservedCacheNodesOfferingId() {
        return this.reservedCacheNodesOfferingId;
    }

    public final String cacheNodeType() {
        return this.cacheNodeType;
    }

    public final Integer duration() {
        return this.duration;
    }

    public final Double fixedPrice() {
        return this.fixedPrice;
    }

    public final Double usagePrice() {
        return this.usagePrice;
    }

    public final String productDescription() {
        return this.productDescription;
    }

    public final String offeringType() {
        return this.offeringType;
    }

    public final boolean hasRecurringCharges() {
        return this.recurringCharges != null && !(this.recurringCharges instanceof SdkAutoConstructList);
    }

    public final List<RecurringCharge> recurringCharges() {
        return this.recurringCharges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedCacheNodesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.usagePrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.productDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecurringCharges() ? this.recurringCharges() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedCacheNodesOffering)) {
            return false;
        }
        ReservedCacheNodesOffering other = (ReservedCacheNodesOffering)obj;
        return Objects.equals(this.reservedCacheNodesOfferingId(), other.reservedCacheNodesOfferingId()) && Objects.equals(this.cacheNodeType(), other.cacheNodeType()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.fixedPrice(), other.fixedPrice()) && Objects.equals(this.usagePrice(), other.usagePrice()) && Objects.equals(this.productDescription(), other.productDescription()) && Objects.equals(this.offeringType(), other.offeringType()) && this.hasRecurringCharges() == other.hasRecurringCharges() && Objects.equals(this.recurringCharges(), other.recurringCharges());
    }

    public final String toString() {
        return ToString.builder((String)"ReservedCacheNodesOffering").add("ReservedCacheNodesOfferingId", (Object)this.reservedCacheNodesOfferingId()).add("CacheNodeType", (Object)this.cacheNodeType()).add("Duration", (Object)this.duration()).add("FixedPrice", (Object)this.fixedPrice()).add("UsagePrice", (Object)this.usagePrice()).add("ProductDescription", (Object)this.productDescription()).add("OfferingType", (Object)this.offeringType()).add("RecurringCharges", this.hasRecurringCharges() ? this.recurringCharges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedCacheNodesOfferingId": {
                return Optional.ofNullable(clazz.cast(this.reservedCacheNodesOfferingId()));
            }
            case "CacheNodeType": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeType()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "FixedPrice": {
                return Optional.ofNullable(clazz.cast(this.fixedPrice()));
            }
            case "UsagePrice": {
                return Optional.ofNullable(clazz.cast(this.usagePrice()));
            }
            case "ProductDescription": {
                return Optional.ofNullable(clazz.cast(this.productDescription()));
            }
            case "OfferingType": {
                return Optional.ofNullable(clazz.cast(this.offeringType()));
            }
            case "RecurringCharges": {
                return Optional.ofNullable(clazz.cast(this.recurringCharges()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservedCacheNodesOffering, T> g) {
        return obj -> g.apply((ReservedCacheNodesOffering)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reservedCacheNodesOfferingId;
        private String cacheNodeType;
        private Integer duration;
        private Double fixedPrice;
        private Double usagePrice;
        private String productDescription;
        private String offeringType;
        private List<RecurringCharge> recurringCharges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedCacheNodesOffering model) {
            this.reservedCacheNodesOfferingId(model.reservedCacheNodesOfferingId);
            this.cacheNodeType(model.cacheNodeType);
            this.duration(model.duration);
            this.fixedPrice(model.fixedPrice);
            this.usagePrice(model.usagePrice);
            this.productDescription(model.productDescription);
            this.offeringType(model.offeringType);
            this.recurringCharges(model.recurringCharges);
        }

        public final String getReservedCacheNodesOfferingId() {
            return this.reservedCacheNodesOfferingId;
        }

        @Override
        public final Builder reservedCacheNodesOfferingId(String reservedCacheNodesOfferingId) {
            this.reservedCacheNodesOfferingId = reservedCacheNodesOfferingId;
            return this;
        }

        public final void setReservedCacheNodesOfferingId(String reservedCacheNodesOfferingId) {
            this.reservedCacheNodesOfferingId = reservedCacheNodesOfferingId;
        }

        public final String getCacheNodeType() {
            return this.cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Double getFixedPrice() {
            return this.fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final void setFixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        public final Double getUsagePrice() {
            return this.usagePrice;
        }

        @Override
        public final Builder usagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final void setUsagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
        }

        public final String getProductDescription() {
            return this.productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        public final Collection<RecurringCharge.Builder> getRecurringCharges() {
            if (this.recurringCharges instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recurringCharges != null ? (Collection)this.recurringCharges.stream().map(RecurringCharge::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge ... recurringCharges) {
            this.recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(Consumer<RecurringCharge.Builder> ... recurringCharges) {
            this.recurringCharges(Stream.of(recurringCharges).map(c -> (RecurringCharge)((RecurringCharge.Builder)RecurringCharge.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copyFromBuilder(recurringCharges);
        }

        public ReservedCacheNodesOffering build() {
            return new ReservedCacheNodesOffering(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservedCacheNodesOffering> {
        public Builder reservedCacheNodesOfferingId(String var1);

        public Builder cacheNodeType(String var1);

        public Builder duration(Integer var1);

        public Builder fixedPrice(Double var1);

        public Builder usagePrice(Double var1);

        public Builder productDescription(String var1);

        public Builder offeringType(String var1);

        public Builder recurringCharges(Collection<RecurringCharge> var1);

        public Builder recurringCharges(RecurringCharge ... var1);

        public Builder recurringCharges(Consumer<RecurringCharge.Builder> ... var1);
    }
}

