/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.CacheNodeIdsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CacheParameterGroupStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CacheParameterGroupStatus> {
    private static final SdkField<String> CACHE_PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheParameterGroupName").getter(CacheParameterGroupStatus.getter(CacheParameterGroupStatus::cacheParameterGroupName)).setter(CacheParameterGroupStatus.setter(Builder::cacheParameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroupName").build()}).build();
    private static final SdkField<String> PARAMETER_APPLY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterApplyStatus").getter(CacheParameterGroupStatus.getter(CacheParameterGroupStatus::parameterApplyStatus)).setter(CacheParameterGroupStatus.setter(Builder::parameterApplyStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterApplyStatus").build()}).build();
    private static final SdkField<List<String>> CACHE_NODE_IDS_TO_REBOOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CacheNodeIdsToReboot").getter(CacheParameterGroupStatus.getter(CacheParameterGroupStatus::cacheNodeIdsToReboot)).setter(CacheParameterGroupStatus.setter(Builder::cacheNodeIdsToReboot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeIdsToReboot").build(), ListTrait.builder().memberLocationName("CacheNodeId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeId").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_PARAMETER_GROUP_NAME_FIELD, PARAMETER_APPLY_STATUS_FIELD, CACHE_NODE_IDS_TO_REBOOT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String cacheParameterGroupName;
    private final String parameterApplyStatus;
    private final List<String> cacheNodeIdsToReboot;

    private CacheParameterGroupStatus(BuilderImpl builder) {
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.parameterApplyStatus = builder.parameterApplyStatus;
        this.cacheNodeIdsToReboot = builder.cacheNodeIdsToReboot;
    }

    public String cacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public String parameterApplyStatus() {
        return this.parameterApplyStatus;
    }

    public boolean hasCacheNodeIdsToReboot() {
        return this.cacheNodeIdsToReboot != null && !(this.cacheNodeIdsToReboot instanceof SdkAutoConstructList);
    }

    public List<String> cacheNodeIdsToReboot() {
        return this.cacheNodeIdsToReboot;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterApplyStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeIdsToReboot());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheParameterGroupStatus)) {
            return false;
        }
        CacheParameterGroupStatus other = (CacheParameterGroupStatus)obj;
        return Objects.equals(this.cacheParameterGroupName(), other.cacheParameterGroupName()) && Objects.equals(this.parameterApplyStatus(), other.parameterApplyStatus()) && Objects.equals(this.cacheNodeIdsToReboot(), other.cacheNodeIdsToReboot());
    }

    public String toString() {
        return ToString.builder((String)"CacheParameterGroupStatus").add("CacheParameterGroupName", (Object)this.cacheParameterGroupName()).add("ParameterApplyStatus", (Object)this.parameterApplyStatus()).add("CacheNodeIdsToReboot", this.cacheNodeIdsToReboot()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.cacheParameterGroupName()));
            }
            case "ParameterApplyStatus": {
                return Optional.ofNullable(clazz.cast(this.parameterApplyStatus()));
            }
            case "CacheNodeIdsToReboot": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeIdsToReboot()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CacheParameterGroupStatus, T> g) {
        return obj -> g.apply((CacheParameterGroupStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cacheParameterGroupName;
        private String parameterApplyStatus;
        private List<String> cacheNodeIdsToReboot = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CacheParameterGroupStatus model) {
            this.cacheParameterGroupName(model.cacheParameterGroupName);
            this.parameterApplyStatus(model.parameterApplyStatus);
            this.cacheNodeIdsToReboot(model.cacheNodeIdsToReboot);
        }

        public final String getCacheParameterGroupName() {
            return this.cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        public final String getParameterApplyStatus() {
            return this.parameterApplyStatus;
        }

        @Override
        public final Builder parameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
            return this;
        }

        public final void setParameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
        }

        public final Collection<String> getCacheNodeIdsToReboot() {
            return this.cacheNodeIdsToReboot;
        }

        @Override
        public final Builder cacheNodeIdsToReboot(Collection<String> cacheNodeIdsToReboot) {
            this.cacheNodeIdsToReboot = CacheNodeIdsListCopier.copy(cacheNodeIdsToReboot);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodeIdsToReboot(String ... cacheNodeIdsToReboot) {
            this.cacheNodeIdsToReboot(Arrays.asList(cacheNodeIdsToReboot));
            return this;
        }

        public final void setCacheNodeIdsToReboot(Collection<String> cacheNodeIdsToReboot) {
            this.cacheNodeIdsToReboot = CacheNodeIdsListCopier.copy(cacheNodeIdsToReboot);
        }

        public CacheParameterGroupStatus build() {
            return new CacheParameterGroupStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CacheParameterGroupStatus> {
        public Builder cacheParameterGroupName(String var1);

        public Builder parameterApplyStatus(String var1);

        public Builder cacheNodeIdsToReboot(Collection<String> var1);

        public Builder cacheNodeIdsToReboot(String ... var1);
    }
}

