/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.CacheClusterIdListCopier;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchStopUpdateActionRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, BatchStopUpdateActionRequest> {
    private static final SdkField<List<String>> REPLICATION_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicationGroupIds").getter(BatchStopUpdateActionRequest.getter(BatchStopUpdateActionRequest::replicationGroupIds)).setter(BatchStopUpdateActionRequest.setter(Builder::replicationGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CACHE_CLUSTER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CacheClusterIds").getter(BatchStopUpdateActionRequest.getter(BatchStopUpdateActionRequest::cacheClusterIds)).setter(BatchStopUpdateActionRequest.setter(Builder::cacheClusterIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SERVICE_UPDATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceUpdateName").getter(BatchStopUpdateActionRequest.getter(BatchStopUpdateActionRequest::serviceUpdateName)).setter(BatchStopUpdateActionRequest.setter(Builder::serviceUpdateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_IDS_FIELD, CACHE_CLUSTER_IDS_FIELD, SERVICE_UPDATE_NAME_FIELD));
    private final List<String> replicationGroupIds;
    private final List<String> cacheClusterIds;
    private final String serviceUpdateName;

    private BatchStopUpdateActionRequest(BuilderImpl builder) {
        super(builder);
        this.replicationGroupIds = builder.replicationGroupIds;
        this.cacheClusterIds = builder.cacheClusterIds;
        this.serviceUpdateName = builder.serviceUpdateName;
    }

    public boolean hasReplicationGroupIds() {
        return this.replicationGroupIds != null && !(this.replicationGroupIds instanceof SdkAutoConstructList);
    }

    public List<String> replicationGroupIds() {
        return this.replicationGroupIds;
    }

    public boolean hasCacheClusterIds() {
        return this.cacheClusterIds != null && !(this.cacheClusterIds instanceof SdkAutoConstructList);
    }

    public List<String> cacheClusterIds() {
        return this.cacheClusterIds;
    }

    public String serviceUpdateName() {
        return this.serviceUpdateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationGroupIds() ? this.replicationGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCacheClusterIds() ? this.cacheClusterIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceUpdateName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStopUpdateActionRequest)) {
            return false;
        }
        BatchStopUpdateActionRequest other = (BatchStopUpdateActionRequest)((Object)obj);
        return this.hasReplicationGroupIds() == other.hasReplicationGroupIds() && Objects.equals(this.replicationGroupIds(), other.replicationGroupIds()) && this.hasCacheClusterIds() == other.hasCacheClusterIds() && Objects.equals(this.cacheClusterIds(), other.cacheClusterIds()) && Objects.equals(this.serviceUpdateName(), other.serviceUpdateName());
    }

    public String toString() {
        return ToString.builder((String)"BatchStopUpdateActionRequest").add("ReplicationGroupIds", this.hasReplicationGroupIds() ? this.replicationGroupIds() : null).add("CacheClusterIds", this.hasCacheClusterIds() ? this.cacheClusterIds() : null).add("ServiceUpdateName", (Object)this.serviceUpdateName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationGroupIds": {
                return Optional.ofNullable(clazz.cast(this.replicationGroupIds()));
            }
            case "CacheClusterIds": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterIds()));
            }
            case "ServiceUpdateName": {
                return Optional.ofNullable(clazz.cast(this.serviceUpdateName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchStopUpdateActionRequest, T> g) {
        return obj -> g.apply((BatchStopUpdateActionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private List<String> replicationGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> cacheClusterIds = DefaultSdkAutoConstructList.getInstance();
        private String serviceUpdateName;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchStopUpdateActionRequest model) {
            super(model);
            this.replicationGroupIds(model.replicationGroupIds);
            this.cacheClusterIds(model.cacheClusterIds);
            this.serviceUpdateName(model.serviceUpdateName);
        }

        public final Collection<String> getReplicationGroupIds() {
            if (this.replicationGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replicationGroupIds;
        }

        @Override
        public final Builder replicationGroupIds(Collection<String> replicationGroupIds) {
            this.replicationGroupIds = ReplicationGroupIdListCopier.copy(replicationGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroupIds(String ... replicationGroupIds) {
            this.replicationGroupIds(Arrays.asList(replicationGroupIds));
            return this;
        }

        public final void setReplicationGroupIds(Collection<String> replicationGroupIds) {
            this.replicationGroupIds = ReplicationGroupIdListCopier.copy(replicationGroupIds);
        }

        public final Collection<String> getCacheClusterIds() {
            if (this.cacheClusterIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cacheClusterIds;
        }

        @Override
        public final Builder cacheClusterIds(Collection<String> cacheClusterIds) {
            this.cacheClusterIds = CacheClusterIdListCopier.copy(cacheClusterIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheClusterIds(String ... cacheClusterIds) {
            this.cacheClusterIds(Arrays.asList(cacheClusterIds));
            return this;
        }

        public final void setCacheClusterIds(Collection<String> cacheClusterIds) {
            this.cacheClusterIds = CacheClusterIdListCopier.copy(cacheClusterIds);
        }

        public final String getServiceUpdateName() {
            return this.serviceUpdateName;
        }

        @Override
        public final Builder serviceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
            return this;
        }

        public final void setServiceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchStopUpdateActionRequest build() {
            return new BatchStopUpdateActionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchStopUpdateActionRequest> {
        public Builder replicationGroupIds(Collection<String> var1);

        public Builder replicationGroupIds(String ... var1);

        public Builder cacheClusterIds(Collection<String> var1);

        public Builder cacheClusterIds(String ... var1);

        public Builder serviceUpdateName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

