/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class IncreaseNodeGroupsInGlobalReplicationGroupResponse extends ElastiCacheResponse
        implements
        ToCopyableBuilder<IncreaseNodeGroupsInGlobalReplicationGroupResponse.Builder, IncreaseNodeGroupsInGlobalReplicationGroupResponse> {
    private static final SdkField<GlobalReplicationGroup> GLOBAL_REPLICATION_GROUP_FIELD = SdkField
            .<GlobalReplicationGroup> builder(MarshallingType.SDK_POJO)
            .getter(getter(IncreaseNodeGroupsInGlobalReplicationGroupResponse::globalReplicationGroup))
            .setter(setter(Builder::globalReplicationGroup)).constructor(GlobalReplicationGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroup").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(GLOBAL_REPLICATION_GROUP_FIELD));

    private final GlobalReplicationGroup globalReplicationGroup;

    private IncreaseNodeGroupsInGlobalReplicationGroupResponse(BuilderImpl builder) {
        super(builder);
        this.globalReplicationGroup = builder.globalReplicationGroup;
    }

    /**
     * Returns the value of the GlobalReplicationGroup property for this object.
     * 
     * @return The value of the GlobalReplicationGroup property for this object.
     */
    public GlobalReplicationGroup globalReplicationGroup() {
        return globalReplicationGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalReplicationGroup());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncreaseNodeGroupsInGlobalReplicationGroupResponse)) {
            return false;
        }
        IncreaseNodeGroupsInGlobalReplicationGroupResponse other = (IncreaseNodeGroupsInGlobalReplicationGroupResponse) obj;
        return Objects.equals(globalReplicationGroup(), other.globalReplicationGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("IncreaseNodeGroupsInGlobalReplicationGroupResponse")
                .add("GlobalReplicationGroup", globalReplicationGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalReplicationGroup":
            return Optional.ofNullable(clazz.cast(globalReplicationGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IncreaseNodeGroupsInGlobalReplicationGroupResponse, T> g) {
        return obj -> g.apply((IncreaseNodeGroupsInGlobalReplicationGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, IncreaseNodeGroupsInGlobalReplicationGroupResponse> {
        /**
         * Sets the value of the GlobalReplicationGroup property for this object.
         *
         * @param globalReplicationGroup
         *        The new value for the GlobalReplicationGroup property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalReplicationGroup(GlobalReplicationGroup globalReplicationGroup);

        /**
         * Sets the value of the GlobalReplicationGroup property for this object.
         *
         * This is a convenience that creates an instance of the {@link GlobalReplicationGroup.Builder} avoiding the
         * need to create one manually via {@link GlobalReplicationGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link GlobalReplicationGroup.Builder#build()} is called immediately and
         * its result is passed to {@link #globalReplicationGroup(GlobalReplicationGroup)}.
         * 
         * @param globalReplicationGroup
         *        a consumer that will call methods on {@link GlobalReplicationGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalReplicationGroup(GlobalReplicationGroup)
         */
        default Builder globalReplicationGroup(Consumer<GlobalReplicationGroup.Builder> globalReplicationGroup) {
            return globalReplicationGroup(GlobalReplicationGroup.builder().applyMutation(globalReplicationGroup).build());
        }
    }

    static final class BuilderImpl extends ElastiCacheResponse.BuilderImpl implements Builder {
        private GlobalReplicationGroup globalReplicationGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(IncreaseNodeGroupsInGlobalReplicationGroupResponse model) {
            super(model);
            globalReplicationGroup(model.globalReplicationGroup);
        }

        public final GlobalReplicationGroup.Builder getGlobalReplicationGroup() {
            return globalReplicationGroup != null ? globalReplicationGroup.toBuilder() : null;
        }

        @Override
        public final Builder globalReplicationGroup(GlobalReplicationGroup globalReplicationGroup) {
            this.globalReplicationGroup = globalReplicationGroup;
            return this;
        }

        public final void setGlobalReplicationGroup(GlobalReplicationGroup.BuilderImpl globalReplicationGroup) {
            this.globalReplicationGroup = globalReplicationGroup != null ? globalReplicationGroup.build() : null;
        }

        @Override
        public IncreaseNodeGroupsInGlobalReplicationGroupResponse build() {
            return new IncreaseNodeGroupsInGlobalReplicationGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
