/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>CreateCacheParameterGroup</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CacheParameterGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<CacheParameterGroup.Builder, CacheParameterGroup> {
    private static final SdkField<String> CACHE_PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CacheParameterGroup::cacheParameterGroupName)).setter(setter(Builder::cacheParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroupName").build())
            .build();

    private static final SdkField<String> CACHE_PARAMETER_GROUP_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CacheParameterGroup::cacheParameterGroupFamily)).setter(setter(Builder::cacheParameterGroupFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroupFamily").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CacheParameterGroup::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Boolean> IS_GLOBAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CacheParameterGroup::isGlobal)).setter(setter(Builder::isGlobal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsGlobal").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CacheParameterGroup::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CACHE_PARAMETER_GROUP_NAME_FIELD, CACHE_PARAMETER_GROUP_FAMILY_FIELD, DESCRIPTION_FIELD, IS_GLOBAL_FIELD, ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cacheParameterGroupName;

    private final String cacheParameterGroupFamily;

    private final String description;

    private final Boolean isGlobal;

    private final String arn;

    private CacheParameterGroup(BuilderImpl builder) {
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.cacheParameterGroupFamily = builder.cacheParameterGroupFamily;
        this.description = builder.description;
        this.isGlobal = builder.isGlobal;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The name of the cache parameter group.
     * </p>
     * 
     * @return The name of the cache parameter group.
     */
    public String cacheParameterGroupName() {
        return cacheParameterGroupName;
    }

    /**
     * <p>
     * The name of the cache parameter group family that this cache parameter group is compatible with.
     * </p>
     * <p>
     * Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>redis2.6</code> |
     * <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> |
     * </p>
     * 
     * @return The name of the cache parameter group family that this cache parameter group is compatible with.</p>
     *         <p>
     *         Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>redis2.6</code> |
     *         <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> |
     */
    public String cacheParameterGroupFamily() {
        return cacheParameterGroupFamily;
    }

    /**
     * <p>
     * The description for this cache parameter group.
     * </p>
     * 
     * @return The description for this cache parameter group.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Indicates whether the parameter group is associated with a Global Datastore
     * </p>
     * 
     * @return Indicates whether the parameter group is associated with a Global Datastore
     */
    public Boolean isGlobal() {
        return isGlobal;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the cache parameter group.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the cache parameter group.
     */
    public String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cacheParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(cacheParameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(isGlobal());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheParameterGroup)) {
            return false;
        }
        CacheParameterGroup other = (CacheParameterGroup) obj;
        return Objects.equals(cacheParameterGroupName(), other.cacheParameterGroupName())
                && Objects.equals(cacheParameterGroupFamily(), other.cacheParameterGroupFamily())
                && Objects.equals(description(), other.description()) && Objects.equals(isGlobal(), other.isGlobal())
                && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CacheParameterGroup").add("CacheParameterGroupName", cacheParameterGroupName())
                .add("CacheParameterGroupFamily", cacheParameterGroupFamily()).add("Description", description())
                .add("IsGlobal", isGlobal()).add("ARN", arn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheParameterGroupName":
            return Optional.ofNullable(clazz.cast(cacheParameterGroupName()));
        case "CacheParameterGroupFamily":
            return Optional.ofNullable(clazz.cast(cacheParameterGroupFamily()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "IsGlobal":
            return Optional.ofNullable(clazz.cast(isGlobal()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CacheParameterGroup, T> g) {
        return obj -> g.apply((CacheParameterGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CacheParameterGroup> {
        /**
         * <p>
         * The name of the cache parameter group.
         * </p>
         * 
         * @param cacheParameterGroupName
         *        The name of the cache parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheParameterGroupName(String cacheParameterGroupName);

        /**
         * <p>
         * The name of the cache parameter group family that this cache parameter group is compatible with.
         * </p>
         * <p>
         * Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>redis2.6</code> |
         * <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> |
         * </p>
         * 
         * @param cacheParameterGroupFamily
         *        The name of the cache parameter group family that this cache parameter group is compatible with.</p>
         *        <p>
         *        Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>redis2.6</code> |
         *        <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> |
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheParameterGroupFamily(String cacheParameterGroupFamily);

        /**
         * <p>
         * The description for this cache parameter group.
         * </p>
         * 
         * @param description
         *        The description for this cache parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Indicates whether the parameter group is associated with a Global Datastore
         * </p>
         * 
         * @param isGlobal
         *        Indicates whether the parameter group is associated with a Global Datastore
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isGlobal(Boolean isGlobal);

        /**
         * <p>
         * The ARN (Amazon Resource Name) of the cache parameter group.
         * </p>
         * 
         * @param arn
         *        The ARN (Amazon Resource Name) of the cache parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String cacheParameterGroupName;

        private String cacheParameterGroupFamily;

        private String description;

        private Boolean isGlobal;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheParameterGroup model) {
            cacheParameterGroupName(model.cacheParameterGroupName);
            cacheParameterGroupFamily(model.cacheParameterGroupFamily);
            description(model.description);
            isGlobal(model.isGlobal);
            arn(model.arn);
        }

        public final String getCacheParameterGroupName() {
            return cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        public final String getCacheParameterGroupFamily() {
            return cacheParameterGroupFamily;
        }

        @Override
        public final Builder cacheParameterGroupFamily(String cacheParameterGroupFamily) {
            this.cacheParameterGroupFamily = cacheParameterGroupFamily;
            return this;
        }

        public final void setCacheParameterGroupFamily(String cacheParameterGroupFamily) {
            this.cacheParameterGroupFamily = cacheParameterGroupFamily;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getIsGlobal() {
            return isGlobal;
        }

        @Override
        public final Builder isGlobal(Boolean isGlobal) {
            this.isGlobal = isGlobal;
            return this;
        }

        public final void setIsGlobal(Boolean isGlobal) {
            this.isGlobal = isGlobal;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public CacheParameterGroup build() {
            return new CacheParameterGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
