/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheResponse;
import software.amazon.awssdk.services.elasticache.model.ProcessedUpdateAction;
import software.amazon.awssdk.services.elasticache.model.ProcessedUpdateActionListCopier;
import software.amazon.awssdk.services.elasticache.model.UnprocessedUpdateAction;
import software.amazon.awssdk.services.elasticache.model.UnprocessedUpdateActionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchApplyUpdateActionResponse
extends ElastiCacheResponse
implements ToCopyableBuilder<Builder, BatchApplyUpdateActionResponse> {
    private static final SdkField<List<ProcessedUpdateAction>> PROCESSED_UPDATE_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchApplyUpdateActionResponse.getter(BatchApplyUpdateActionResponse::processedUpdateActions)).setter(BatchApplyUpdateActionResponse.setter(Builder::processedUpdateActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessedUpdateActions").build(), ListTrait.builder().memberLocationName("ProcessedUpdateAction").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProcessedUpdateAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessedUpdateAction").build()}).build()).build()}).build();
    private static final SdkField<List<UnprocessedUpdateAction>> UNPROCESSED_UPDATE_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchApplyUpdateActionResponse.getter(BatchApplyUpdateActionResponse::unprocessedUpdateActions)).setter(BatchApplyUpdateActionResponse.setter(Builder::unprocessedUpdateActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedUpdateActions").build(), ListTrait.builder().memberLocationName("UnprocessedUpdateAction").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnprocessedUpdateAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedUpdateAction").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROCESSED_UPDATE_ACTIONS_FIELD, UNPROCESSED_UPDATE_ACTIONS_FIELD));
    private final List<ProcessedUpdateAction> processedUpdateActions;
    private final List<UnprocessedUpdateAction> unprocessedUpdateActions;

    private BatchApplyUpdateActionResponse(BuilderImpl builder) {
        super(builder);
        this.processedUpdateActions = builder.processedUpdateActions;
        this.unprocessedUpdateActions = builder.unprocessedUpdateActions;
    }

    public boolean hasProcessedUpdateActions() {
        return this.processedUpdateActions != null && !(this.processedUpdateActions instanceof SdkAutoConstructList);
    }

    public List<ProcessedUpdateAction> processedUpdateActions() {
        return this.processedUpdateActions;
    }

    public boolean hasUnprocessedUpdateActions() {
        return this.unprocessedUpdateActions != null && !(this.unprocessedUpdateActions instanceof SdkAutoConstructList);
    }

    public List<UnprocessedUpdateAction> unprocessedUpdateActions() {
        return this.unprocessedUpdateActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.processedUpdateActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.unprocessedUpdateActions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchApplyUpdateActionResponse)) {
            return false;
        }
        BatchApplyUpdateActionResponse other = (BatchApplyUpdateActionResponse)((Object)obj);
        return Objects.equals(this.processedUpdateActions(), other.processedUpdateActions()) && Objects.equals(this.unprocessedUpdateActions(), other.unprocessedUpdateActions());
    }

    public String toString() {
        return ToString.builder((String)"BatchApplyUpdateActionResponse").add("ProcessedUpdateActions", this.processedUpdateActions()).add("UnprocessedUpdateActions", this.unprocessedUpdateActions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProcessedUpdateActions": {
                return Optional.ofNullable(clazz.cast(this.processedUpdateActions()));
            }
            case "UnprocessedUpdateActions": {
                return Optional.ofNullable(clazz.cast(this.unprocessedUpdateActions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchApplyUpdateActionResponse, T> g) {
        return obj -> g.apply((BatchApplyUpdateActionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheResponse.BuilderImpl
    implements Builder {
        private List<ProcessedUpdateAction> processedUpdateActions = DefaultSdkAutoConstructList.getInstance();
        private List<UnprocessedUpdateAction> unprocessedUpdateActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchApplyUpdateActionResponse model) {
            super(model);
            this.processedUpdateActions(model.processedUpdateActions);
            this.unprocessedUpdateActions(model.unprocessedUpdateActions);
        }

        public final Collection<ProcessedUpdateAction.Builder> getProcessedUpdateActions() {
            return this.processedUpdateActions != null ? (Collection)this.processedUpdateActions.stream().map(ProcessedUpdateAction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder processedUpdateActions(Collection<ProcessedUpdateAction> processedUpdateActions) {
            this.processedUpdateActions = ProcessedUpdateActionListCopier.copy(processedUpdateActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processedUpdateActions(ProcessedUpdateAction ... processedUpdateActions) {
            this.processedUpdateActions(Arrays.asList(processedUpdateActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processedUpdateActions(Consumer<ProcessedUpdateAction.Builder> ... processedUpdateActions) {
            this.processedUpdateActions(Stream.of(processedUpdateActions).map(c -> (ProcessedUpdateAction)((ProcessedUpdateAction.Builder)ProcessedUpdateAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProcessedUpdateActions(Collection<ProcessedUpdateAction.BuilderImpl> processedUpdateActions) {
            this.processedUpdateActions = ProcessedUpdateActionListCopier.copyFromBuilder(processedUpdateActions);
        }

        public final Collection<UnprocessedUpdateAction.Builder> getUnprocessedUpdateActions() {
            return this.unprocessedUpdateActions != null ? (Collection)this.unprocessedUpdateActions.stream().map(UnprocessedUpdateAction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unprocessedUpdateActions(Collection<UnprocessedUpdateAction> unprocessedUpdateActions) {
            this.unprocessedUpdateActions = UnprocessedUpdateActionListCopier.copy(unprocessedUpdateActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedUpdateActions(UnprocessedUpdateAction ... unprocessedUpdateActions) {
            this.unprocessedUpdateActions(Arrays.asList(unprocessedUpdateActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedUpdateActions(Consumer<UnprocessedUpdateAction.Builder> ... unprocessedUpdateActions) {
            this.unprocessedUpdateActions(Stream.of(unprocessedUpdateActions).map(c -> (UnprocessedUpdateAction)((UnprocessedUpdateAction.Builder)UnprocessedUpdateAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUnprocessedUpdateActions(Collection<UnprocessedUpdateAction.BuilderImpl> unprocessedUpdateActions) {
            this.unprocessedUpdateActions = UnprocessedUpdateActionListCopier.copyFromBuilder(unprocessedUpdateActions);
        }

        @Override
        public BatchApplyUpdateActionResponse build() {
            return new BatchApplyUpdateActionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElastiCacheResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchApplyUpdateActionResponse> {
        public Builder processedUpdateActions(Collection<ProcessedUpdateAction> var1);

        public Builder processedUpdateActions(ProcessedUpdateAction ... var1);

        public Builder processedUpdateActions(Consumer<ProcessedUpdateAction.Builder> ... var1);

        public Builder unprocessedUpdateActions(Collection<UnprocessedUpdateAction> var1);

        public Builder unprocessedUpdateActions(UnprocessedUpdateAction ... var1);

        public Builder unprocessedUpdateActions(Consumer<UnprocessedUpdateAction.Builder> ... var1);
    }
}

