/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the subnet associated with a cluster. This parameter refers to subnets defined in Amazon Virtual Private
 * Cloud (Amazon VPC) and used with ElastiCache.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Subnet implements SdkPojo, Serializable, ToCopyableBuilder<Subnet.Builder, Subnet> {
    private static final SdkField<String> SUBNET_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Subnet::subnetIdentifier)).setter(setter(Builder::subnetIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIdentifier").build()).build();

    private static final SdkField<AvailabilityZone> SUBNET_AVAILABILITY_ZONE_FIELD = SdkField
            .<AvailabilityZone> builder(MarshallingType.SDK_POJO).getter(getter(Subnet::subnetAvailabilityZone))
            .setter(setter(Builder::subnetAvailabilityZone)).constructor(AvailabilityZone::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetAvailabilityZone").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_IDENTIFIER_FIELD,
            SUBNET_AVAILABILITY_ZONE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String subnetIdentifier;

    private final AvailabilityZone subnetAvailabilityZone;

    private Subnet(BuilderImpl builder) {
        this.subnetIdentifier = builder.subnetIdentifier;
        this.subnetAvailabilityZone = builder.subnetAvailabilityZone;
    }

    /**
     * <p>
     * The unique identifier for the subnet.
     * </p>
     * 
     * @return The unique identifier for the subnet.
     */
    public String subnetIdentifier() {
        return subnetIdentifier;
    }

    /**
     * <p>
     * The Availability Zone associated with the subnet.
     * </p>
     * 
     * @return The Availability Zone associated with the subnet.
     */
    public AvailabilityZone subnetAvailabilityZone() {
        return subnetAvailabilityZone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subnetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(subnetAvailabilityZone());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subnet)) {
            return false;
        }
        Subnet other = (Subnet) obj;
        return Objects.equals(subnetIdentifier(), other.subnetIdentifier())
                && Objects.equals(subnetAvailabilityZone(), other.subnetAvailabilityZone());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Subnet").add("SubnetIdentifier", subnetIdentifier())
                .add("SubnetAvailabilityZone", subnetAvailabilityZone()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubnetIdentifier":
            return Optional.ofNullable(clazz.cast(subnetIdentifier()));
        case "SubnetAvailabilityZone":
            return Optional.ofNullable(clazz.cast(subnetAvailabilityZone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Subnet, T> g) {
        return obj -> g.apply((Subnet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Subnet> {
        /**
         * <p>
         * The unique identifier for the subnet.
         * </p>
         * 
         * @param subnetIdentifier
         *        The unique identifier for the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIdentifier(String subnetIdentifier);

        /**
         * <p>
         * The Availability Zone associated with the subnet.
         * </p>
         * 
         * @param subnetAvailabilityZone
         *        The Availability Zone associated with the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetAvailabilityZone(AvailabilityZone subnetAvailabilityZone);

        /**
         * <p>
         * The Availability Zone associated with the subnet.
         * </p>
         * This is a convenience that creates an instance of the {@link AvailabilityZone.Builder} avoiding the need to
         * create one manually via {@link AvailabilityZone#builder()}.
         *
         * When the {@link Consumer} completes, {@link AvailabilityZone.Builder#build()} is called immediately and its
         * result is passed to {@link #subnetAvailabilityZone(AvailabilityZone)}.
         * 
         * @param subnetAvailabilityZone
         *        a consumer that will call methods on {@link AvailabilityZone.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subnetAvailabilityZone(AvailabilityZone)
         */
        default Builder subnetAvailabilityZone(Consumer<AvailabilityZone.Builder> subnetAvailabilityZone) {
            return subnetAvailabilityZone(AvailabilityZone.builder().applyMutation(subnetAvailabilityZone).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String subnetIdentifier;

        private AvailabilityZone subnetAvailabilityZone;

        private BuilderImpl() {
        }

        private BuilderImpl(Subnet model) {
            subnetIdentifier(model.subnetIdentifier);
            subnetAvailabilityZone(model.subnetAvailabilityZone);
        }

        public final String getSubnetIdentifier() {
            return subnetIdentifier;
        }

        @Override
        public final Builder subnetIdentifier(String subnetIdentifier) {
            this.subnetIdentifier = subnetIdentifier;
            return this;
        }

        public final void setSubnetIdentifier(String subnetIdentifier) {
            this.subnetIdentifier = subnetIdentifier;
        }

        public final AvailabilityZone.Builder getSubnetAvailabilityZone() {
            return subnetAvailabilityZone != null ? subnetAvailabilityZone.toBuilder() : null;
        }

        @Override
        public final Builder subnetAvailabilityZone(AvailabilityZone subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone;
            return this;
        }

        public final void setSubnetAvailabilityZone(AvailabilityZone.BuilderImpl subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone != null ? subnetAvailabilityZone.build() : null;
        }

        @Override
        public Subnet build() {
            return new Subnet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
