/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMigrationResponse extends ElastiCacheResponse implements
        ToCopyableBuilder<StartMigrationResponse.Builder, StartMigrationResponse> {
    private static final SdkField<ReplicationGroup> REPLICATION_GROUP_FIELD = SdkField
            .<ReplicationGroup> builder(MarshallingType.SDK_POJO).getter(getter(StartMigrationResponse::replicationGroup))
            .setter(setter(Builder::replicationGroup)).constructor(ReplicationGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_FIELD));

    private final ReplicationGroup replicationGroup;

    private StartMigrationResponse(BuilderImpl builder) {
        super(builder);
        this.replicationGroup = builder.replicationGroup;
    }

    /**
     * Returns the value of the ReplicationGroup property for this object.
     * 
     * @return The value of the ReplicationGroup property for this object.
     */
    public ReplicationGroup replicationGroup() {
        return replicationGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroup());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMigrationResponse)) {
            return false;
        }
        StartMigrationResponse other = (StartMigrationResponse) obj;
        return Objects.equals(replicationGroup(), other.replicationGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartMigrationResponse").add("ReplicationGroup", replicationGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationGroup":
            return Optional.ofNullable(clazz.cast(replicationGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartMigrationResponse, T> g) {
        return obj -> g.apply((StartMigrationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartMigrationResponse> {
        /**
         * Sets the value of the ReplicationGroup property for this object.
         *
         * @param replicationGroup
         *        The new value for the ReplicationGroup property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroup(ReplicationGroup replicationGroup);

        /**
         * Sets the value of the ReplicationGroup property for this object.
         *
         * This is a convenience that creates an instance of the {@link ReplicationGroup.Builder} avoiding the need to
         * create one manually via {@link ReplicationGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReplicationGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #replicationGroup(ReplicationGroup)}.
         * 
         * @param replicationGroup
         *        a consumer that will call methods on {@link ReplicationGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationGroup(ReplicationGroup)
         */
        default Builder replicationGroup(Consumer<ReplicationGroup.Builder> replicationGroup) {
            return replicationGroup(ReplicationGroup.builder().applyMutation(replicationGroup).build());
        }
    }

    static final class BuilderImpl extends ElastiCacheResponse.BuilderImpl implements Builder {
        private ReplicationGroup replicationGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMigrationResponse model) {
            super(model);
            replicationGroup(model.replicationGroup);
        }

        public final ReplicationGroup.Builder getReplicationGroup() {
            return replicationGroup != null ? replicationGroup.toBuilder() : null;
        }

        @Override
        public final Builder replicationGroup(ReplicationGroup replicationGroup) {
            this.replicationGroup = replicationGroup;
            return this;
        }

        public final void setReplicationGroup(ReplicationGroup.BuilderImpl replicationGroup) {
            this.replicationGroup = replicationGroup != null ? replicationGroup.build() : null;
        }

        @Override
        public StartMigrationResponse build() {
            return new StartMigrationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
