/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>ModifyReplicationGroups</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyReplicationGroupRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<ModifyReplicationGroupRequest.Builder, ModifyReplicationGroupRequest> {
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyReplicationGroupRequest::replicationGroupId)).setter(setter(Builder::replicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build())
            .build();

    private static final SdkField<String> REPLICATION_GROUP_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyReplicationGroupRequest::replicationGroupDescription))
            .setter(setter(Builder::replicationGroupDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupDescription")
                    .build()).build();

    private static final SdkField<String> PRIMARY_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyReplicationGroupRequest::primaryClusterId)).setter(setter(Builder::primaryClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryClusterId").build()).build();

    private static final SdkField<String> SNAPSHOTTING_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyReplicationGroupRequest::snapshottingClusterId)).setter(setter(Builder::snapshottingClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshottingClusterId").build())
            .build();

    private static final SdkField<Boolean> AUTOMATIC_FAILOVER_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ModifyReplicationGroupRequest::automaticFailoverEnabled))
            .setter(setter(Builder::automaticFailoverEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticFailoverEnabled").build())
            .build();

    private static final SdkField<String> NODE_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyReplicationGroupRequest::nodeGroupId)).setter(setter(Builder::nodeGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupId").build()).build();

    private static final SdkField<List<String>> CACHE_SECURITY_GROUP_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ModifyReplicationGroupRequest::cacheSecurityGroupNames))
            .setter(setter(Builder::cacheSecurityGroupNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroupNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("CacheSecurityGroupName")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("CacheSecurityGroupName").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ModifyReplicationGroupRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SecurityGroupId").build()).build()).build()).build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyReplicationGroupRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<String> NOTIFICATION_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyReplicationGroupRequest::notificationTopicArn)).setter(setter(Builder::notificationTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTopicArn").build())
            .build();

    private static final SdkField<String> CACHE_PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyReplicationGroupRequest::cacheParameterGroupName))
            .setter(setter(Builder::cacheParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroupName").build())
            .build();

    private static final SdkField<String> NOTIFICATION_TOPIC_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyReplicationGroupRequest::notificationTopicStatus))
            .setter(setter(Builder::notificationTopicStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTopicStatus").build())
            .build();

    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ModifyReplicationGroupRequest::applyImmediately)).setter(setter(Builder::applyImmediately))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyReplicationGroupRequest::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ModifyReplicationGroupRequest::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ModifyReplicationGroupRequest::snapshotRetentionLimit))
            .setter(setter(Builder::snapshotRetentionLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build())
            .build();

    private static final SdkField<String> SNAPSHOT_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyReplicationGroupRequest::snapshotWindow)).setter(setter(Builder::snapshotWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotWindow").build()).build();

    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyReplicationGroupRequest::cacheNodeType)).setter(setter(Builder::cacheNodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()).build();

    private static final SdkField<String> AUTH_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyReplicationGroupRequest::authToken)).setter(setter(Builder::authToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthToken").build()).build();

    private static final SdkField<String> AUTH_TOKEN_UPDATE_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyReplicationGroupRequest::authTokenUpdateStrategyAsString))
            .setter(setter(Builder::authTokenUpdateStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenUpdateStrategy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_ID_FIELD,
            REPLICATION_GROUP_DESCRIPTION_FIELD, PRIMARY_CLUSTER_ID_FIELD, SNAPSHOTTING_CLUSTER_ID_FIELD,
            AUTOMATIC_FAILOVER_ENABLED_FIELD, NODE_GROUP_ID_FIELD, CACHE_SECURITY_GROUP_NAMES_FIELD, SECURITY_GROUP_IDS_FIELD,
            PREFERRED_MAINTENANCE_WINDOW_FIELD, NOTIFICATION_TOPIC_ARN_FIELD, CACHE_PARAMETER_GROUP_NAME_FIELD,
            NOTIFICATION_TOPIC_STATUS_FIELD, APPLY_IMMEDIATELY_FIELD, ENGINE_VERSION_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD,
            SNAPSHOT_RETENTION_LIMIT_FIELD, SNAPSHOT_WINDOW_FIELD, CACHE_NODE_TYPE_FIELD, AUTH_TOKEN_FIELD,
            AUTH_TOKEN_UPDATE_STRATEGY_FIELD));

    private final String replicationGroupId;

    private final String replicationGroupDescription;

    private final String primaryClusterId;

    private final String snapshottingClusterId;

    private final Boolean automaticFailoverEnabled;

    private final String nodeGroupId;

    private final List<String> cacheSecurityGroupNames;

    private final List<String> securityGroupIds;

    private final String preferredMaintenanceWindow;

    private final String notificationTopicArn;

    private final String cacheParameterGroupName;

    private final String notificationTopicStatus;

    private final Boolean applyImmediately;

    private final String engineVersion;

    private final Boolean autoMinorVersionUpgrade;

    private final Integer snapshotRetentionLimit;

    private final String snapshotWindow;

    private final String cacheNodeType;

    private final String authToken;

    private final String authTokenUpdateStrategy;

    private ModifyReplicationGroupRequest(BuilderImpl builder) {
        super(builder);
        this.replicationGroupId = builder.replicationGroupId;
        this.replicationGroupDescription = builder.replicationGroupDescription;
        this.primaryClusterId = builder.primaryClusterId;
        this.snapshottingClusterId = builder.snapshottingClusterId;
        this.automaticFailoverEnabled = builder.automaticFailoverEnabled;
        this.nodeGroupId = builder.nodeGroupId;
        this.cacheSecurityGroupNames = builder.cacheSecurityGroupNames;
        this.securityGroupIds = builder.securityGroupIds;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.notificationTopicArn = builder.notificationTopicArn;
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.notificationTopicStatus = builder.notificationTopicStatus;
        this.applyImmediately = builder.applyImmediately;
        this.engineVersion = builder.engineVersion;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.cacheNodeType = builder.cacheNodeType;
        this.authToken = builder.authToken;
        this.authTokenUpdateStrategy = builder.authTokenUpdateStrategy;
    }

    /**
     * <p>
     * The identifier of the replication group to modify.
     * </p>
     * 
     * @return The identifier of the replication group to modify.
     */
    public String replicationGroupId() {
        return replicationGroupId;
    }

    /**
     * <p>
     * A description for the replication group. Maximum length is 255 characters.
     * </p>
     * 
     * @return A description for the replication group. Maximum length is 255 characters.
     */
    public String replicationGroupDescription() {
        return replicationGroupDescription;
    }

    /**
     * <p>
     * For replication groups with a single primary, if this parameter is specified, ElastiCache promotes the specified
     * cluster in the specified replication group to the primary role. The nodes of all other clusters in the
     * replication group are read replicas.
     * </p>
     * 
     * @return For replication groups with a single primary, if this parameter is specified, ElastiCache promotes the
     *         specified cluster in the specified replication group to the primary role. The nodes of all other clusters
     *         in the replication group are read replicas.
     */
    public String primaryClusterId() {
        return primaryClusterId;
    }

    /**
     * <p>
     * The cluster ID that is used as the daily snapshot source for the replication group. This parameter cannot be set
     * for Redis (cluster mode enabled) replication groups.
     * </p>
     * 
     * @return The cluster ID that is used as the daily snapshot source for the replication group. This parameter cannot
     *         be set for Redis (cluster mode enabled) replication groups.
     */
    public String snapshottingClusterId() {
        return snapshottingClusterId;
    }

    /**
     * <p>
     * Determines whether a read replica is automatically promoted to read/write primary if the existing primary
     * encounters a failure.
     * </p>
     * <p>
     * Valid values: <code>true</code> | <code>false</code>
     * </p>
     * <p>
     * Amazon ElastiCache for Redis does not support Multi-AZ with automatic failover on:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Redis versions earlier than 2.8.6.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis (cluster mode disabled): T1 node types.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis (cluster mode enabled): T1 node types.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Determines whether a read replica is automatically promoted to read/write primary if the existing primary
     *         encounters a failure.</p>
     *         <p>
     *         Valid values: <code>true</code> | <code>false</code>
     *         </p>
     *         <p>
     *         Amazon ElastiCache for Redis does not support Multi-AZ with automatic failover on:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Redis versions earlier than 2.8.6.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis (cluster mode disabled): T1 node types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis (cluster mode enabled): T1 node types.
     *         </p>
     *         </li>
     */
    public Boolean automaticFailoverEnabled() {
        return automaticFailoverEnabled;
    }

    /**
     * <p>
     * Deprecated. This parameter is not used.
     * </p>
     * 
     * @return Deprecated. This parameter is not used.
     */
    public String nodeGroupId() {
        return nodeGroupId;
    }

    /**
     * Returns true if the CacheSecurityGroupNames property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCacheSecurityGroupNames() {
        return cacheSecurityGroupNames != null && !(cacheSecurityGroupNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of cache security group names to authorize for the clusters in this replication group. This change is
     * asynchronously applied as soon as possible.
     * </p>
     * <p>
     * This parameter can be used only with replication group containing clusters running outside of an Amazon Virtual
     * Private Cloud (Amazon VPC).
     * </p>
     * <p>
     * Constraints: Must contain no more than 255 alphanumeric characters. Must not be <code>Default</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCacheSecurityGroupNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of cache security group names to authorize for the clusters in this replication group. This change
     *         is asynchronously applied as soon as possible.</p>
     *         <p>
     *         This parameter can be used only with replication group containing clusters running outside of an Amazon
     *         Virtual Private Cloud (Amazon VPC).
     *         </p>
     *         <p>
     *         Constraints: Must contain no more than 255 alphanumeric characters. Must not be <code>Default</code>.
     */
    public List<String> cacheSecurityGroupNames() {
        return cacheSecurityGroupNames;
    }

    /**
     * Returns true if the SecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the VPC Security Groups associated with the clusters in the replication group.
     * </p>
     * <p>
     * This parameter can be used only with replication group containing clusters running in an Amazon Virtual Private
     * Cloud (Amazon VPC).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the VPC Security Groups associated with the clusters in the replication group.</p>
     *         <p>
     *         This parameter can be used only with replication group containing clusters running in an Amazon Virtual
     *         Private Cloud (Amazon VPC).
     */
    public List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range
     * in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     * </p>
     * <p>
     * Valid values for <code>ddd</code> are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>sun</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mon</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tue</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>wed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>thu</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fri</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sat</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>sun:23:00-mon:01:30</code>
     * </p>
     * 
     * @return Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as
     *         a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60
     *         minute period.</p>
     *         <p>
     *         Valid values for <code>ddd</code> are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>sun</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>mon</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tue</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>wed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>thu</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fri</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sat</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>sun:23:00-mon:01:30</code>
     */
    public String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.
     * </p>
     * <note>
     * <p>
     * The Amazon SNS topic owner must be same as the replication group owner.
     * </p>
     * </note>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.</p> <note>
     *         <p>
     *         The Amazon SNS topic owner must be same as the replication group owner.
     *         </p>
     */
    public String notificationTopicArn() {
        return notificationTopicArn;
    }

    /**
     * <p>
     * The name of the cache parameter group to apply to all of the clusters in this replication group. This change is
     * asynchronously applied as soon as possible for parameters when the <code>ApplyImmediately</code> parameter is
     * specified as <code>true</code> for this request.
     * </p>
     * 
     * @return The name of the cache parameter group to apply to all of the clusters in this replication group. This
     *         change is asynchronously applied as soon as possible for parameters when the
     *         <code>ApplyImmediately</code> parameter is specified as <code>true</code> for this request.
     */
    public String cacheParameterGroupName() {
        return cacheParameterGroupName;
    }

    /**
     * <p>
     * The status of the Amazon SNS notification topic for the replication group. Notifications are sent only if the
     * status is <code>active</code>.
     * </p>
     * <p>
     * Valid values: <code>active</code> | <code>inactive</code>
     * </p>
     * 
     * @return The status of the Amazon SNS notification topic for the replication group. Notifications are sent only if
     *         the status is <code>active</code>.</p>
     *         <p>
     *         Valid values: <code>active</code> | <code>inactive</code>
     */
    public String notificationTopicStatus() {
        return notificationTopicStatus;
    }

    /**
     * <p>
     * If <code>true</code>, this parameter causes the modifications in this request and any pending modifications to be
     * applied, asynchronously and as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code>
     * setting for the replication group.
     * </p>
     * <p>
     * If <code>false</code>, changes to the nodes in the replication group are applied on the next maintenance reboot,
     * or the next failure reboot, whichever occurs first.
     * </p>
     * <p>
     * Valid values: <code>true</code> | <code>false</code>
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return If <code>true</code>, this parameter causes the modifications in this request and any pending
     *         modifications to be applied, asynchronously and as soon as possible, regardless of the
     *         <code>PreferredMaintenanceWindow</code> setting for the replication group.</p>
     *         <p>
     *         If <code>false</code>, changes to the nodes in the replication group are applied on the next maintenance
     *         reboot, or the next failure reboot, whichever occurs first.
     *         </p>
     *         <p>
     *         Valid values: <code>true</code> | <code>false</code>
     *         </p>
     *         <p>
     *         Default: <code>false</code>
     */
    public Boolean applyImmediately() {
        return applyImmediately;
    }

    /**
     * <p>
     * The upgraded version of the cache engine to be run on the clusters in the replication group.
     * </p>
     * <p>
     * <b>Important:</b> You can upgrade to a newer engine version (see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting
     * a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an
     * earlier engine version, you must delete the existing replication group and create it anew with the earlier engine
     * version.
     * </p>
     * 
     * @return The upgraded version of the cache engine to be run on the clusters in the replication group.</p>
     *         <p>
     *         <b>Important:</b> You can upgrade to a newer engine version (see <a
     *         href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement"
     *         >Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you
     *         want to use an earlier engine version, you must delete the existing replication group and create it anew
     *         with the earlier engine version.
     */
    public String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * This parameter is currently disabled.
     * </p>
     * 
     * @return This parameter is currently disabled.
     */
    public Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * The number of days for which ElastiCache retains automatic node group (shard) snapshots before deleting them. For
     * example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5
     * days before being deleted.
     * </p>
     * <p>
     * <b>Important</b> If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.
     * </p>
     * 
     * @return The number of days for which ElastiCache retains automatic node group (shard) snapshots before deleting
     *         them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today
     *         is retained for 5 days before being deleted.</p>
     *         <p>
     *         <b>Important</b> If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.
     */
    public Integer snapshotRetentionLimit() {
        return snapshotRetentionLimit;
    }

    /**
     * <p>
     * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of the node group (shard)
     * specified by <code>SnapshottingClusterId</code>.
     * </p>
     * <p>
     * Example: <code>05:00-09:00</code>
     * </p>
     * <p>
     * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     * </p>
     * 
     * @return The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of the node group
     *         (shard) specified by <code>SnapshottingClusterId</code>.</p>
     *         <p>
     *         Example: <code>05:00-09:00</code>
     *         </p>
     *         <p>
     *         If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     */
    public String snapshotWindow() {
        return snapshotWindow;
    }

    /**
     * <p>
     * A valid cache node type that you want to scale this replication group to.
     * </p>
     * 
     * @return A valid cache node type that you want to scale this replication group to.
     */
    public String cacheNodeType() {
        return cacheNodeType;
    }

    /**
     * <p>
     * Reserved parameter. The password used to access a password protected server. This parameter must be specified
     * with the <code>auth-token-update-strategy </code> parameter. Password constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be only printable ASCII characters
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 16 characters and no more than 128 characters in length
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot contain any of the following characters: '/', '"', or '@', '%'
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH</a>.
     * </p>
     * 
     * @return Reserved parameter. The password used to access a password protected server. This parameter must be
     *         specified with the <code>auth-token-update-strategy </code> parameter. Password constraints:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be only printable ASCII characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 16 characters and no more than 128 characters in length
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot contain any of the following characters: '/', '"', or '@', '%'
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH</a>.
     */
    public String authToken() {
        return authToken;
    }

    /**
     * <p>
     * Specifies the strategy to use to update the AUTH token. This parameter must be specified with the
     * <code>auth-token</code> parameter. Possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Rotate
     * </p>
     * </li>
     * <li>
     * <p>
     * Set
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis
     * AUTH</a>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authTokenUpdateStrategy} will return {@link AuthTokenUpdateStrategyType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #authTokenUpdateStrategyAsString}.
     * </p>
     * 
     * @return Specifies the strategy to use to update the AUTH token. This parameter must be specified with the
     *         <code>auth-token</code> parameter. Possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Rotate
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Set
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with
     *         Redis AUTH</a>
     * @see AuthTokenUpdateStrategyType
     */
    public AuthTokenUpdateStrategyType authTokenUpdateStrategy() {
        return AuthTokenUpdateStrategyType.fromValue(authTokenUpdateStrategy);
    }

    /**
     * <p>
     * Specifies the strategy to use to update the AUTH token. This parameter must be specified with the
     * <code>auth-token</code> parameter. Possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Rotate
     * </p>
     * </li>
     * <li>
     * <p>
     * Set
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis
     * AUTH</a>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authTokenUpdateStrategy} will return {@link AuthTokenUpdateStrategyType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #authTokenUpdateStrategyAsString}.
     * </p>
     * 
     * @return Specifies the strategy to use to update the AUTH token. This parameter must be specified with the
     *         <code>auth-token</code> parameter. Possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Rotate
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Set
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with
     *         Redis AUTH</a>
     * @see AuthTokenUpdateStrategyType
     */
    public String authTokenUpdateStrategyAsString() {
        return authTokenUpdateStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(primaryClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshottingClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(automaticFailoverEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(nodeGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(cacheSecurityGroupNames());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(notificationTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(cacheParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(notificationTopicStatus());
        hashCode = 31 * hashCode + Objects.hashCode(applyImmediately());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(authToken());
        hashCode = 31 * hashCode + Objects.hashCode(authTokenUpdateStrategyAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReplicationGroupRequest)) {
            return false;
        }
        ModifyReplicationGroupRequest other = (ModifyReplicationGroupRequest) obj;
        return Objects.equals(replicationGroupId(), other.replicationGroupId())
                && Objects.equals(replicationGroupDescription(), other.replicationGroupDescription())
                && Objects.equals(primaryClusterId(), other.primaryClusterId())
                && Objects.equals(snapshottingClusterId(), other.snapshottingClusterId())
                && Objects.equals(automaticFailoverEnabled(), other.automaticFailoverEnabled())
                && Objects.equals(nodeGroupId(), other.nodeGroupId())
                && Objects.equals(cacheSecurityGroupNames(), other.cacheSecurityGroupNames())
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(notificationTopicArn(), other.notificationTopicArn())
                && Objects.equals(cacheParameterGroupName(), other.cacheParameterGroupName())
                && Objects.equals(notificationTopicStatus(), other.notificationTopicStatus())
                && Objects.equals(applyImmediately(), other.applyImmediately())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(snapshotRetentionLimit(), other.snapshotRetentionLimit())
                && Objects.equals(snapshotWindow(), other.snapshotWindow())
                && Objects.equals(cacheNodeType(), other.cacheNodeType()) && Objects.equals(authToken(), other.authToken())
                && Objects.equals(authTokenUpdateStrategyAsString(), other.authTokenUpdateStrategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyReplicationGroupRequest").add("ReplicationGroupId", replicationGroupId())
                .add("ReplicationGroupDescription", replicationGroupDescription()).add("PrimaryClusterId", primaryClusterId())
                .add("SnapshottingClusterId", snapshottingClusterId())
                .add("AutomaticFailoverEnabled", automaticFailoverEnabled()).add("NodeGroupId", nodeGroupId())
                .add("CacheSecurityGroupNames", cacheSecurityGroupNames()).add("SecurityGroupIds", securityGroupIds())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("NotificationTopicArn", notificationTopicArn()).add("CacheParameterGroupName", cacheParameterGroupName())
                .add("NotificationTopicStatus", notificationTopicStatus()).add("ApplyImmediately", applyImmediately())
                .add("EngineVersion", engineVersion()).add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade())
                .add("SnapshotRetentionLimit", snapshotRetentionLimit()).add("SnapshotWindow", snapshotWindow())
                .add("CacheNodeType", cacheNodeType()).add("AuthToken", authToken())
                .add("AuthTokenUpdateStrategy", authTokenUpdateStrategyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationGroupId":
            return Optional.ofNullable(clazz.cast(replicationGroupId()));
        case "ReplicationGroupDescription":
            return Optional.ofNullable(clazz.cast(replicationGroupDescription()));
        case "PrimaryClusterId":
            return Optional.ofNullable(clazz.cast(primaryClusterId()));
        case "SnapshottingClusterId":
            return Optional.ofNullable(clazz.cast(snapshottingClusterId()));
        case "AutomaticFailoverEnabled":
            return Optional.ofNullable(clazz.cast(automaticFailoverEnabled()));
        case "NodeGroupId":
            return Optional.ofNullable(clazz.cast(nodeGroupId()));
        case "CacheSecurityGroupNames":
            return Optional.ofNullable(clazz.cast(cacheSecurityGroupNames()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "NotificationTopicArn":
            return Optional.ofNullable(clazz.cast(notificationTopicArn()));
        case "CacheParameterGroupName":
            return Optional.ofNullable(clazz.cast(cacheParameterGroupName()));
        case "NotificationTopicStatus":
            return Optional.ofNullable(clazz.cast(notificationTopicStatus()));
        case "ApplyImmediately":
            return Optional.ofNullable(clazz.cast(applyImmediately()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "SnapshotRetentionLimit":
            return Optional.ofNullable(clazz.cast(snapshotRetentionLimit()));
        case "SnapshotWindow":
            return Optional.ofNullable(clazz.cast(snapshotWindow()));
        case "CacheNodeType":
            return Optional.ofNullable(clazz.cast(cacheNodeType()));
        case "AuthToken":
            return Optional.ofNullable(clazz.cast(authToken()));
        case "AuthTokenUpdateStrategy":
            return Optional.ofNullable(clazz.cast(authTokenUpdateStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyReplicationGroupRequest, T> g) {
        return obj -> g.apply((ModifyReplicationGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyReplicationGroupRequest> {
        /**
         * <p>
         * The identifier of the replication group to modify.
         * </p>
         * 
         * @param replicationGroupId
         *        The identifier of the replication group to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupId(String replicationGroupId);

        /**
         * <p>
         * A description for the replication group. Maximum length is 255 characters.
         * </p>
         * 
         * @param replicationGroupDescription
         *        A description for the replication group. Maximum length is 255 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupDescription(String replicationGroupDescription);

        /**
         * <p>
         * For replication groups with a single primary, if this parameter is specified, ElastiCache promotes the
         * specified cluster in the specified replication group to the primary role. The nodes of all other clusters in
         * the replication group are read replicas.
         * </p>
         * 
         * @param primaryClusterId
         *        For replication groups with a single primary, if this parameter is specified, ElastiCache promotes the
         *        specified cluster in the specified replication group to the primary role. The nodes of all other
         *        clusters in the replication group are read replicas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryClusterId(String primaryClusterId);

        /**
         * <p>
         * The cluster ID that is used as the daily snapshot source for the replication group. This parameter cannot be
         * set for Redis (cluster mode enabled) replication groups.
         * </p>
         * 
         * @param snapshottingClusterId
         *        The cluster ID that is used as the daily snapshot source for the replication group. This parameter
         *        cannot be set for Redis (cluster mode enabled) replication groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshottingClusterId(String snapshottingClusterId);

        /**
         * <p>
         * Determines whether a read replica is automatically promoted to read/write primary if the existing primary
         * encounters a failure.
         * </p>
         * <p>
         * Valid values: <code>true</code> | <code>false</code>
         * </p>
         * <p>
         * Amazon ElastiCache for Redis does not support Multi-AZ with automatic failover on:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Redis versions earlier than 2.8.6.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis (cluster mode disabled): T1 node types.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis (cluster mode enabled): T1 node types.
         * </p>
         * </li>
         * </ul>
         * 
         * @param automaticFailoverEnabled
         *        Determines whether a read replica is automatically promoted to read/write primary if the existing
         *        primary encounters a failure.</p>
         *        <p>
         *        Valid values: <code>true</code> | <code>false</code>
         *        </p>
         *        <p>
         *        Amazon ElastiCache for Redis does not support Multi-AZ with automatic failover on:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Redis versions earlier than 2.8.6.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis (cluster mode disabled): T1 node types.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis (cluster mode enabled): T1 node types.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticFailoverEnabled(Boolean automaticFailoverEnabled);

        /**
         * <p>
         * Deprecated. This parameter is not used.
         * </p>
         * 
         * @param nodeGroupId
         *        Deprecated. This parameter is not used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeGroupId(String nodeGroupId);

        /**
         * <p>
         * A list of cache security group names to authorize for the clusters in this replication group. This change is
         * asynchronously applied as soon as possible.
         * </p>
         * <p>
         * This parameter can be used only with replication group containing clusters running outside of an Amazon
         * Virtual Private Cloud (Amazon VPC).
         * </p>
         * <p>
         * Constraints: Must contain no more than 255 alphanumeric characters. Must not be <code>Default</code>.
         * </p>
         * 
         * @param cacheSecurityGroupNames
         *        A list of cache security group names to authorize for the clusters in this replication group. This
         *        change is asynchronously applied as soon as possible.</p>
         *        <p>
         *        This parameter can be used only with replication group containing clusters running outside of an
         *        Amazon Virtual Private Cloud (Amazon VPC).
         *        </p>
         *        <p>
         *        Constraints: Must contain no more than 255 alphanumeric characters. Must not be <code>Default</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames);

        /**
         * <p>
         * A list of cache security group names to authorize for the clusters in this replication group. This change is
         * asynchronously applied as soon as possible.
         * </p>
         * <p>
         * This parameter can be used only with replication group containing clusters running outside of an Amazon
         * Virtual Private Cloud (Amazon VPC).
         * </p>
         * <p>
         * Constraints: Must contain no more than 255 alphanumeric characters. Must not be <code>Default</code>.
         * </p>
         * 
         * @param cacheSecurityGroupNames
         *        A list of cache security group names to authorize for the clusters in this replication group. This
         *        change is asynchronously applied as soon as possible.</p>
         *        <p>
         *        This parameter can be used only with replication group containing clusters running outside of an
         *        Amazon Virtual Private Cloud (Amazon VPC).
         *        </p>
         *        <p>
         *        Constraints: Must contain no more than 255 alphanumeric characters. Must not be <code>Default</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSecurityGroupNames(String... cacheSecurityGroupNames);

        /**
         * <p>
         * Specifies the VPC Security Groups associated with the clusters in the replication group.
         * </p>
         * <p>
         * This parameter can be used only with replication group containing clusters running in an Amazon Virtual
         * Private Cloud (Amazon VPC).
         * </p>
         * 
         * @param securityGroupIds
         *        Specifies the VPC Security Groups associated with the clusters in the replication group.</p>
         *        <p>
         *        This parameter can be used only with replication group containing clusters running in an Amazon
         *        Virtual Private Cloud (Amazon VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * Specifies the VPC Security Groups associated with the clusters in the replication group.
         * </p>
         * <p>
         * This parameter can be used only with replication group containing clusters running in an Amazon Virtual
         * Private Cloud (Amazon VPC).
         * </p>
         * 
         * @param securityGroupIds
         *        Specifies the VPC Security Groups associated with the clusters in the replication group.</p>
         *        <p>
         *        This parameter can be used only with replication group containing clusters running in an Amazon
         *        Virtual Private Cloud (Amazon VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a
         * range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute
         * period.
         * </p>
         * <p>
         * Valid values for <code>ddd</code> are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>sun</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mon</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tue</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>wed</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>thu</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fri</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sat</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>sun:23:00-mon:01:30</code>
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        Specifies the weekly time range during which maintenance on the cluster is performed. It is specified
         *        as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a
         *        60 minute period.</p>
         *        <p>
         *        Valid values for <code>ddd</code> are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>sun</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mon</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tue</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>wed</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>thu</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fri</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sat</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>sun:23:00-mon:01:30</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.
         * </p>
         * <note>
         * <p>
         * The Amazon SNS topic owner must be same as the replication group owner.
         * </p>
         * </note>
         * 
         * @param notificationTopicArn
         *        The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.</p> <note>
         *        <p>
         *        The Amazon SNS topic owner must be same as the replication group owner.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTopicArn(String notificationTopicArn);

        /**
         * <p>
         * The name of the cache parameter group to apply to all of the clusters in this replication group. This change
         * is asynchronously applied as soon as possible for parameters when the <code>ApplyImmediately</code> parameter
         * is specified as <code>true</code> for this request.
         * </p>
         * 
         * @param cacheParameterGroupName
         *        The name of the cache parameter group to apply to all of the clusters in this replication group. This
         *        change is asynchronously applied as soon as possible for parameters when the
         *        <code>ApplyImmediately</code> parameter is specified as <code>true</code> for this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheParameterGroupName(String cacheParameterGroupName);

        /**
         * <p>
         * The status of the Amazon SNS notification topic for the replication group. Notifications are sent only if the
         * status is <code>active</code>.
         * </p>
         * <p>
         * Valid values: <code>active</code> | <code>inactive</code>
         * </p>
         * 
         * @param notificationTopicStatus
         *        The status of the Amazon SNS notification topic for the replication group. Notifications are sent only
         *        if the status is <code>active</code>.</p>
         *        <p>
         *        Valid values: <code>active</code> | <code>inactive</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTopicStatus(String notificationTopicStatus);

        /**
         * <p>
         * If <code>true</code>, this parameter causes the modifications in this request and any pending modifications
         * to be applied, asynchronously and as soon as possible, regardless of the
         * <code>PreferredMaintenanceWindow</code> setting for the replication group.
         * </p>
         * <p>
         * If <code>false</code>, changes to the nodes in the replication group are applied on the next maintenance
         * reboot, or the next failure reboot, whichever occurs first.
         * </p>
         * <p>
         * Valid values: <code>true</code> | <code>false</code>
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param applyImmediately
         *        If <code>true</code>, this parameter causes the modifications in this request and any pending
         *        modifications to be applied, asynchronously and as soon as possible, regardless of the
         *        <code>PreferredMaintenanceWindow</code> setting for the replication group.</p>
         *        <p>
         *        If <code>false</code>, changes to the nodes in the replication group are applied on the next
         *        maintenance reboot, or the next failure reboot, whichever occurs first.
         *        </p>
         *        <p>
         *        Valid values: <code>true</code> | <code>false</code>
         *        </p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyImmediately(Boolean applyImmediately);

        /**
         * <p>
         * The upgraded version of the cache engine to be run on the clusters in the replication group.
         * </p>
         * <p>
         * <b>Important:</b> You can upgrade to a newer engine version (see <a
         * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement"
         * >Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you
         * want to use an earlier engine version, you must delete the existing replication group and create it anew with
         * the earlier engine version.
         * </p>
         * 
         * @param engineVersion
         *        The upgraded version of the cache engine to be run on the clusters in the replication group.</p>
         *        <p>
         *        <b>Important:</b> You can upgrade to a newer engine version (see <a href=
         *        "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement"
         *        >Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If
         *        you want to use an earlier engine version, you must delete the existing replication group and create
         *        it anew with the earlier engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * This parameter is currently disabled.
         * </p>
         * 
         * @param autoMinorVersionUpgrade
         *        This parameter is currently disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * The number of days for which ElastiCache retains automatic node group (shard) snapshots before deleting them.
         * For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained
         * for 5 days before being deleted.
         * </p>
         * <p>
         * <b>Important</b> If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.
         * </p>
         * 
         * @param snapshotRetentionLimit
         *        The number of days for which ElastiCache retains automatic node group (shard) snapshots before
         *        deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was
         *        taken today is retained for 5 days before being deleted.</p>
         *        <p>
         *        <b>Important</b> If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotRetentionLimit(Integer snapshotRetentionLimit);

        /**
         * <p>
         * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of the node group
         * (shard) specified by <code>SnapshottingClusterId</code>.
         * </p>
         * <p>
         * Example: <code>05:00-09:00</code>
         * </p>
         * <p>
         * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
         * </p>
         * 
         * @param snapshotWindow
         *        The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of the node
         *        group (shard) specified by <code>SnapshottingClusterId</code>.</p>
         *        <p>
         *        Example: <code>05:00-09:00</code>
         *        </p>
         *        <p>
         *        If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotWindow(String snapshotWindow);

        /**
         * <p>
         * A valid cache node type that you want to scale this replication group to.
         * </p>
         * 
         * @param cacheNodeType
         *        A valid cache node type that you want to scale this replication group to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeType(String cacheNodeType);

        /**
         * <p>
         * Reserved parameter. The password used to access a password protected server. This parameter must be specified
         * with the <code>auth-token-update-strategy </code> parameter. Password constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be only printable ASCII characters
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be at least 16 characters and no more than 128 characters in length
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot contain any of the following characters: '/', '"', or '@', '%'
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH</a>.
         * </p>
         * 
         * @param authToken
         *        Reserved parameter. The password used to access a password protected server. This parameter must be
         *        specified with the <code>auth-token-update-strategy </code> parameter. Password constraints:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be only printable ASCII characters
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be at least 16 characters and no more than 128 characters in length
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot contain any of the following characters: '/', '"', or '@', '%'
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authToken(String authToken);

        /**
         * <p>
         * Specifies the strategy to use to update the AUTH token. This parameter must be specified with the
         * <code>auth-token</code> parameter. Possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Rotate
         * </p>
         * </li>
         * <li>
         * <p>
         * Set
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis
         * AUTH</a>
         * </p>
         * 
         * @param authTokenUpdateStrategy
         *        Specifies the strategy to use to update the AUTH token. This parameter must be specified with the
         *        <code>auth-token</code> parameter. Possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Rotate
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Set
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with
         *        Redis AUTH</a>
         * @see AuthTokenUpdateStrategyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthTokenUpdateStrategyType
         */
        Builder authTokenUpdateStrategy(String authTokenUpdateStrategy);

        /**
         * <p>
         * Specifies the strategy to use to update the AUTH token. This parameter must be specified with the
         * <code>auth-token</code> parameter. Possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Rotate
         * </p>
         * </li>
         * <li>
         * <p>
         * Set
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis
         * AUTH</a>
         * </p>
         * 
         * @param authTokenUpdateStrategy
         *        Specifies the strategy to use to update the AUTH token. This parameter must be specified with the
         *        <code>auth-token</code> parameter. Possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Rotate
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Set
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with
         *        Redis AUTH</a>
         * @see AuthTokenUpdateStrategyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthTokenUpdateStrategyType
         */
        Builder authTokenUpdateStrategy(AuthTokenUpdateStrategyType authTokenUpdateStrategy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String replicationGroupId;

        private String replicationGroupDescription;

        private String primaryClusterId;

        private String snapshottingClusterId;

        private Boolean automaticFailoverEnabled;

        private String nodeGroupId;

        private List<String> cacheSecurityGroupNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String preferredMaintenanceWindow;

        private String notificationTopicArn;

        private String cacheParameterGroupName;

        private String notificationTopicStatus;

        private Boolean applyImmediately;

        private String engineVersion;

        private Boolean autoMinorVersionUpgrade;

        private Integer snapshotRetentionLimit;

        private String snapshotWindow;

        private String cacheNodeType;

        private String authToken;

        private String authTokenUpdateStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyReplicationGroupRequest model) {
            super(model);
            replicationGroupId(model.replicationGroupId);
            replicationGroupDescription(model.replicationGroupDescription);
            primaryClusterId(model.primaryClusterId);
            snapshottingClusterId(model.snapshottingClusterId);
            automaticFailoverEnabled(model.automaticFailoverEnabled);
            nodeGroupId(model.nodeGroupId);
            cacheSecurityGroupNames(model.cacheSecurityGroupNames);
            securityGroupIds(model.securityGroupIds);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            notificationTopicArn(model.notificationTopicArn);
            cacheParameterGroupName(model.cacheParameterGroupName);
            notificationTopicStatus(model.notificationTopicStatus);
            applyImmediately(model.applyImmediately);
            engineVersion(model.engineVersion);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            snapshotRetentionLimit(model.snapshotRetentionLimit);
            snapshotWindow(model.snapshotWindow);
            cacheNodeType(model.cacheNodeType);
            authToken(model.authToken);
            authTokenUpdateStrategy(model.authTokenUpdateStrategy);
        }

        public final String getReplicationGroupId() {
            return replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final String getReplicationGroupDescription() {
            return replicationGroupDescription;
        }

        @Override
        public final Builder replicationGroupDescription(String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
            return this;
        }

        public final void setReplicationGroupDescription(String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
        }

        public final String getPrimaryClusterId() {
            return primaryClusterId;
        }

        @Override
        public final Builder primaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
            return this;
        }

        public final void setPrimaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
        }

        public final String getSnapshottingClusterId() {
            return snapshottingClusterId;
        }

        @Override
        public final Builder snapshottingClusterId(String snapshottingClusterId) {
            this.snapshottingClusterId = snapshottingClusterId;
            return this;
        }

        public final void setSnapshottingClusterId(String snapshottingClusterId) {
            this.snapshottingClusterId = snapshottingClusterId;
        }

        public final Boolean getAutomaticFailoverEnabled() {
            return automaticFailoverEnabled;
        }

        @Override
        public final Builder automaticFailoverEnabled(Boolean automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
            return this;
        }

        public final void setAutomaticFailoverEnabled(Boolean automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
        }

        public final String getNodeGroupId() {
            return nodeGroupId;
        }

        @Override
        public final Builder nodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
            return this;
        }

        public final void setNodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
        }

        public final Collection<String> getCacheSecurityGroupNames() {
            return cacheSecurityGroupNames;
        }

        @Override
        public final Builder cacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSecurityGroupNames(String... cacheSecurityGroupNames) {
            cacheSecurityGroupNames(Arrays.asList(cacheSecurityGroupNames));
            return this;
        }

        public final void setCacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
        }

        public final Collection<String> getSecurityGroupIds() {
            return securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final String getNotificationTopicArn() {
            return notificationTopicArn;
        }

        @Override
        public final Builder notificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
            return this;
        }

        public final void setNotificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
        }

        public final String getCacheParameterGroupName() {
            return cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        public final String getNotificationTopicStatus() {
            return notificationTopicStatus;
        }

        @Override
        public final Builder notificationTopicStatus(String notificationTopicStatus) {
            this.notificationTopicStatus = notificationTopicStatus;
            return this;
        }

        public final void setNotificationTopicStatus(String notificationTopicStatus) {
            this.notificationTopicStatus = notificationTopicStatus;
        }

        public final Boolean getApplyImmediately() {
            return applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final Integer getSnapshotRetentionLimit() {
            return snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        public final String getSnapshotWindow() {
            return snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        public final String getCacheNodeType() {
            return cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        public final String getAuthToken() {
            return authToken;
        }

        @Override
        public final Builder authToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public final void setAuthToken(String authToken) {
            this.authToken = authToken;
        }

        public final String getAuthTokenUpdateStrategyAsString() {
            return authTokenUpdateStrategy;
        }

        @Override
        public final Builder authTokenUpdateStrategy(String authTokenUpdateStrategy) {
            this.authTokenUpdateStrategy = authTokenUpdateStrategy;
            return this;
        }

        @Override
        public final Builder authTokenUpdateStrategy(AuthTokenUpdateStrategyType authTokenUpdateStrategy) {
            this.authTokenUpdateStrategy(authTokenUpdateStrategy == null ? null : authTokenUpdateStrategy.toString());
            return this;
        }

        public final void setAuthTokenUpdateStrategy(String authTokenUpdateStrategy) {
            this.authTokenUpdateStrategy = authTokenUpdateStrategy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyReplicationGroupRequest build() {
            return new ModifyReplicationGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
