/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeServiceUpdatesRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<DescribeServiceUpdatesRequest.Builder, DescribeServiceUpdatesRequest> {
    private static final SdkField<String> SERVICE_UPDATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeServiceUpdatesRequest::serviceUpdateName)).setter(setter(Builder::serviceUpdateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateName").build()).build();

    private static final SdkField<List<String>> SERVICE_UPDATE_STATUS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeServiceUpdatesRequest::serviceUpdateStatusAsStrings))
            .setter(setter(Builder::serviceUpdateStatusWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateStatus").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeServiceUpdatesRequest::maxRecords)).setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeServiceUpdatesRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_UPDATE_NAME_FIELD,
            SERVICE_UPDATE_STATUS_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD));

    private final String serviceUpdateName;

    private final List<String> serviceUpdateStatus;

    private final Integer maxRecords;

    private final String marker;

    private DescribeServiceUpdatesRequest(BuilderImpl builder) {
        super(builder);
        this.serviceUpdateName = builder.serviceUpdateName;
        this.serviceUpdateStatus = builder.serviceUpdateStatus;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The unique ID of the service update
     * </p>
     * 
     * @return The unique ID of the service update
     */
    public String serviceUpdateName() {
        return serviceUpdateName;
    }

    /**
     * <p>
     * The status of the service update
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServiceUpdateStatus()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The status of the service update
     */
    public List<ServiceUpdateStatus> serviceUpdateStatus() {
        return ServiceUpdateStatusListCopier.copyStringToEnum(serviceUpdateStatus);
    }

    /**
     * Returns true if the ServiceUpdateStatus property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasServiceUpdateStatus() {
        return serviceUpdateStatus != null && !(serviceUpdateStatus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The status of the service update
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServiceUpdateStatus()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The status of the service update
     */
    public List<String> serviceUpdateStatusAsStrings() {
        return serviceUpdateStatus;
    }

    /**
     * <p>
     * The maximum number of records to include in the response
     * </p>
     * 
     * @return The maximum number of records to include in the response
     */
    public Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * An optional marker returned from a prior request. Use this marker for pagination of results from this operation.
     * If this parameter is specified, the response includes only records beyond the marker, up to the value specified
     * by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional marker returned from a prior request. Use this marker for pagination of results from this
     *         operation. If this parameter is specified, the response includes only records beyond the marker, up to
     *         the value specified by <code>MaxRecords</code>.
     */
    public String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceUpdateName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceUpdateStatusAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServiceUpdatesRequest)) {
            return false;
        }
        DescribeServiceUpdatesRequest other = (DescribeServiceUpdatesRequest) obj;
        return Objects.equals(serviceUpdateName(), other.serviceUpdateName())
                && Objects.equals(serviceUpdateStatusAsStrings(), other.serviceUpdateStatusAsStrings())
                && Objects.equals(maxRecords(), other.maxRecords()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeServiceUpdatesRequest").add("ServiceUpdateName", serviceUpdateName())
                .add("ServiceUpdateStatus", serviceUpdateStatusAsStrings()).add("MaxRecords", maxRecords())
                .add("Marker", marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceUpdateName":
            return Optional.ofNullable(clazz.cast(serviceUpdateName()));
        case "ServiceUpdateStatus":
            return Optional.ofNullable(clazz.cast(serviceUpdateStatusAsStrings()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeServiceUpdatesRequest, T> g) {
        return obj -> g.apply((DescribeServiceUpdatesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeServiceUpdatesRequest> {
        /**
         * <p>
         * The unique ID of the service update
         * </p>
         * 
         * @param serviceUpdateName
         *        The unique ID of the service update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUpdateName(String serviceUpdateName);

        /**
         * <p>
         * The status of the service update
         * </p>
         * 
         * @param serviceUpdateStatus
         *        The status of the service update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUpdateStatusWithStrings(Collection<String> serviceUpdateStatus);

        /**
         * <p>
         * The status of the service update
         * </p>
         * 
         * @param serviceUpdateStatus
         *        The status of the service update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUpdateStatusWithStrings(String... serviceUpdateStatus);

        /**
         * <p>
         * The status of the service update
         * </p>
         * 
         * @param serviceUpdateStatus
         *        The status of the service update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUpdateStatus(Collection<ServiceUpdateStatus> serviceUpdateStatus);

        /**
         * <p>
         * The status of the service update
         * </p>
         * 
         * @param serviceUpdateStatus
         *        The status of the service update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUpdateStatus(ServiceUpdateStatus... serviceUpdateStatus);

        /**
         * <p>
         * The maximum number of records to include in the response
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of records to include in the response
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * An optional marker returned from a prior request. Use this marker for pagination of results from this
         * operation. If this parameter is specified, the response includes only records beyond the marker, up to the
         * value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional marker returned from a prior request. Use this marker for pagination of results from this
         *        operation. If this parameter is specified, the response includes only records beyond the marker, up to
         *        the value specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String serviceUpdateName;

        private List<String> serviceUpdateStatus = DefaultSdkAutoConstructList.getInstance();

        private Integer maxRecords;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServiceUpdatesRequest model) {
            super(model);
            serviceUpdateName(model.serviceUpdateName);
            serviceUpdateStatusWithStrings(model.serviceUpdateStatus);
            maxRecords(model.maxRecords);
            marker(model.marker);
        }

        public final String getServiceUpdateName() {
            return serviceUpdateName;
        }

        @Override
        public final Builder serviceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
            return this;
        }

        public final void setServiceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
        }

        public final Collection<String> getServiceUpdateStatusAsStrings() {
            return serviceUpdateStatus;
        }

        @Override
        public final Builder serviceUpdateStatusWithStrings(Collection<String> serviceUpdateStatus) {
            this.serviceUpdateStatus = ServiceUpdateStatusListCopier.copy(serviceUpdateStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceUpdateStatusWithStrings(String... serviceUpdateStatus) {
            serviceUpdateStatusWithStrings(Arrays.asList(serviceUpdateStatus));
            return this;
        }

        @Override
        public final Builder serviceUpdateStatus(Collection<ServiceUpdateStatus> serviceUpdateStatus) {
            this.serviceUpdateStatus = ServiceUpdateStatusListCopier.copyEnumToString(serviceUpdateStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceUpdateStatus(ServiceUpdateStatus... serviceUpdateStatus) {
            serviceUpdateStatus(Arrays.asList(serviceUpdateStatus));
            return this;
        }

        public final void setServiceUpdateStatusWithStrings(Collection<String> serviceUpdateStatus) {
            this.serviceUpdateStatus = ServiceUpdateStatusListCopier.copy(serviceUpdateStatus);
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeServiceUpdatesRequest build() {
            return new DescribeServiceUpdatesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
